/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugConsoleTraceTracker;
import org.eclipse.dltk.launching.process.IScriptProcess;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ScriptDebugConsole
extends IOConsole {
    public static final String TYPE = "org.eclipse.dltk.debug.ui.ScriptDebugConsoleType";
    private final ILaunch launch;
    private final IConsoleColorProvider fColorProvider;
    private Set<IScriptProcess> connectedProcesses;
    private List<StreamListener> fStreamListeners = new ArrayList<StreamListener>();

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProcess getProcess() {
        IProcess[] processes = this.launch.getProcesses();
        if (processes.length != 0) {
            return processes[0];
        }
        return null;
    }

    public ScriptDebugConsole(ILaunch launch, String name, ImageDescriptor imageDescriptor, String encoding, IConsoleColorProvider colorProvider) {
        super(name, TYPE, imageDescriptor, encoding, true);
        this.launch = launch;
        this.fColorProvider = colorProvider;
        this.addPatternMatchListener(new ScriptDebugConsoleTraceTracker());
    }

    public void matcherFinished() {
        super.matcherFinished();
    }

    public void partitionerFinished() {
        super.partitionerFinished();
    }

    protected void setName(String name) {
        super.setName(name);
    }

    protected void dispose() {
        this.closeStreams();
        this.disposeStreams();
        super.dispose();
    }

    public synchronized void connect(IScriptProcess process) {
        if (this.connectedProcesses == null) {
            this.connectedProcesses = new HashSet<IScriptProcess>();
        }
        if (this.connectedProcesses.add(process)) {
            IStreamsProxy proxy = process.getScriptStreamsProxy();
            if (proxy == null) {
                return;
            }
            this.connect(proxy);
        }
    }

    public void connect(IStreamsProxy proxy) {
        IStreamMonitor streamMonitor = proxy.getErrorStreamMonitor();
        if (streamMonitor != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
        }
        if ((streamMonitor = proxy.getOutputStreamMonitor()) != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(IStreamMonitor streamMonitor, String streamIdentifier) {
        IStreamMonitor iStreamMonitor = streamMonitor;
        synchronized (iStreamMonitor) {
            IOConsoleOutputStream stream = this.newOutputStream();
            stream.setColor(this.fColorProvider.getColor(streamIdentifier));
            StreamListener listener = new StreamListener(streamMonitor, stream);
            this.fStreamListeners.add(listener);
        }
    }

    private synchronized void closeStreams() {
        for (StreamListener listener : this.fStreamListeners) {
            listener.closeStream();
        }
    }

    private synchronized void disposeStreams() {
        for (StreamListener listener : this.fStreamListeners) {
            listener.dispose();
        }
    }

    private class StreamListener
    implements IStreamListener {
        private IOConsoleOutputStream fStream;
        private IStreamMonitor fStreamMonitor;
        private boolean fFlushed = false;
        private boolean fListenerRemoved = false;

        public StreamListener(IStreamMonitor monitor, IOConsoleOutputStream stream) {
            this.fStream = stream;
            this.fStreamMonitor = monitor;
            this.fStreamMonitor.addListener((IStreamListener)this);
            this.streamAppended(null, monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamAppended(String text, IStreamMonitor monitor) {
            block12: {
                String encoding = ScriptDebugConsole.this.getEncoding();
                if (this.fFlushed) {
                    try {
                        if (this.fStream == null) break block12;
                        if (encoding == null) {
                            this.fStream.write(text);
                            break block12;
                        }
                        this.fStream.write(text.getBytes(encoding));
                    }
                    catch (IOException e) {
                        DLTKDebugUIPlugin.log(e);
                    }
                } else {
                    String contents = null;
                    IStreamMonitor iStreamMonitor = this.fStreamMonitor;
                    synchronized (iStreamMonitor) {
                        this.fFlushed = true;
                        contents = this.fStreamMonitor.getContents();
                        if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                            IFlushableStreamMonitor m = (IFlushableStreamMonitor)this.fStreamMonitor;
                            m.flushContents();
                            m.setBuffered(false);
                        }
                    }
                    try {
                        if (contents != null && contents.length() > 0 && this.fStream != null) {
                            this.fStream.write(contents);
                        }
                    }
                    catch (IOException e) {
                        DLTKDebugUIPlugin.log(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeStream() {
            if (this.fStreamMonitor == null) {
                return;
            }
            IStreamMonitor iStreamMonitor = this.fStreamMonitor;
            synchronized (iStreamMonitor) {
                this.fStreamMonitor.removeListener((IStreamListener)this);
                if (!this.fFlushed) {
                    String contents = this.fStreamMonitor.getContents();
                    this.streamAppended(contents, this.fStreamMonitor);
                }
                this.fListenerRemoved = true;
            }
        }

        public void dispose() {
            if (!this.fListenerRemoved) {
                this.closeStream();
            }
            this.fStreamMonitor = null;
            this.fStream = null;
        }
    }
}

