/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.modisco.infra.browser.custom.core.Activator;
import org.eclipse.modisco.infra.browser.custom.emf.UicustomPackage;
import org.eclipse.modisco.infra.browser.custom.validation.EValidatorAdapter;
import org.eclipse.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.modisco.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.modisco.infra.common.core.internal.resource.IMoDiscoResourceListener;
import org.eclipse.modisco.infra.common.core.internal.resource.MoDiscoResourceListenerGroup;
import org.eclipse.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.common.core.internal.validation.ValidationJob;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.facet.FacetSet;
import org.eclipse.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.modisco.infra.query.core.ModelQuerySetCatalog;

@Deprecated
public class CustomizationsCatalog
extends AbstractMoDiscoCatalog {
    public static final String REGISTRATION_EXTENSION_POINT_ID = "org.eclipse.modisco.infra.browser.custom.core.registration";
    public static final String FILE_EXTENSION = "uiCustom";
    private static CustomizationsCatalog instance = null;
    private Set<String> defaultCustomizations = null;

    public static synchronized CustomizationsCatalog getInstance() {
        if (instance == null) {
            EcoreCatalog.getSingleton();
            ModelQuerySetCatalog.getSingleton();
            FacetSetCatalog.getSingleton();
            instance = new CustomizationsCatalog();
            EValidator validator = EValidator.Registry.INSTANCE.getEValidator((EPackage)UicustomPackage.eINSTANCE);
            if (validator == null) {
                EValidator.Registry.INSTANCE.put((Object)UicustomPackage.eINSTANCE, (Object)new EValidatorAdapter());
            }
        }
        return instance;
    }

    protected String getRootObjectName(EObject rootObject) {
        return ((MetamodelView)rootObject).getName();
    }

    protected String getRootObjectNsUri(EObject rootObject) {
        return "modisco:/customization/" + ((MetamodelView)rootObject).getName();
    }

    protected Class<?> getRootClass() {
        return MetamodelView.class;
    }

    protected String getRegistryExtensionPoint() {
        return REGISTRATION_EXTENSION_POINT_ID;
    }

    public synchronized Collection<MetamodelView> getAllCustomizations() {
        ArrayList<MetamodelView> result = new ArrayList<MetamodelView>();
        for (EObject eObject : this.getAllRootObjects()) {
            if (!(eObject instanceof MetamodelView) || eObject.eResource() == null) continue;
            MetamodelView metamodelView = (MetamodelView)eObject;
            if (metamodelView.getName() != null) {
                metamodelView.setLocation(this.getURI(metamodelView.getName()).toString());
                result.add(metamodelView);
                continue;
            }
            MoDiscoLogger.logError((String)"MetamodelView with null name", (Plugin)Activator.getDefault());
        }
        return result;
    }

    protected String getMoDiscoSubProtocol() {
        return "customization";
    }

    protected Plugin getActivator() {
        return Activator.getDefault();
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    protected void preRemove(IFile declarationFile, String pathName, EObject oldRootObject) {
    }

    protected synchronized void postOpenResource(URI uri, final IFile file, final EObject root) {
        try {
            this.addListenerToReferedResources((MetamodelView)root, new IMoDiscoResourceListener(){

                public void aListenedResourceHasChanged(URI resourceUri, URI dependingResourceURI) {
                    if (root.eResource() != null) {
                        ValidationJob.getInstance().validateAsync(root.eResource(), file, null);
                    }
                }
            });
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private synchronized void addListenerToReferedResources(MetamodelView metamodelView, final IMoDiscoResourceListener listener) throws Exception {
        final String metamodelURI = metamodelView.getMetamodelURI();
        if (metamodelURI == null || metamodelView.eResource() == null) {
            return;
        }
        final URI resourceURI = metamodelView.eResource().getURI();
        FacetSetCatalog.getSingleton();
        AbstractMoDiscoCatalog.whenBuilt((Runnable)new Runnable(){

            @Override
            public void run() {
                Collection allFacetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                for (FacetSet facetSet : allFacetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    MoDiscoResourceListenerGroup listenerGroup = MoDiscoResourceSet.getResourceSetSingleton().getListenerGroup(URI.createURI((String)metamodelURI));
                    listenerGroup.addListener(listener, resourceURI);
                }
            }
        });
    }

    public List<MetamodelView> getRegistryDefaultCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        for (MetamodelView metamodelView : this.getAllCustomizations()) {
            if (!this.isDefaultCustomization(metamodelView.getName())) continue;
            metamodelViews.add(metamodelView);
        }
        return metamodelViews;
    }

    private synchronized boolean isDefaultCustomization(String name) {
        if (this.defaultCustomizations == null) {
            this.defaultCustomizations = new HashSet<String>();
            try {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(REGISTRATION_EXTENSION_POINT_ID);
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    String fileAttribute = configurationElement.getAttribute("file");
                    if (fileAttribute == null) {
                        Activator.logError("Missing 'file' attribute in customization registration extension");
                    } else {
                        String loadByDefaultAttribute = configurationElement.getAttribute("loadByDefault");
                        if (loadByDefaultAttribute != null && loadByDefaultAttribute.equalsIgnoreCase(String.valueOf(Boolean.TRUE))) {
                            String fileName = new Path(fileAttribute).removeFileExtension().lastSegment();
                            this.defaultCustomizations.add(fileName);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Activator.logException(e);
            }
        }
        return this.defaultCustomizations.contains(name);
    }

    public List<MetamodelView> getWorkspaceCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        for (MetamodelView metamodelView : this.getAllCustomizations()) {
            URI uri = URI.createURI((String)metamodelView.getLocation());
            if (!uri.isPlatformResource()) continue;
            metamodelViews.add(metamodelView);
        }
        return metamodelViews;
    }

    public List<MetamodelView> getRegistryCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        for (MetamodelView metamodelView : this.getAllCustomizations()) {
            URI uri = URI.createURI((String)metamodelView.getLocation());
            if (!uri.isPlatformPlugin()) continue;
            metamodelViews.add(metamodelView);
        }
        return metamodelViews;
    }

    public MetamodelView getCustomization(String name) {
        return (MetamodelView)this.getRootObject(name);
    }

    public static Collection<MetamodelView> filterForMetamodel(Collection<MetamodelView> allCustomizations, Collection<EPackage> ePackages) {
        ArrayList<MetamodelView> filteredCustomizations = new ArrayList<MetamodelView>();
        HashSet<EPackage> allReferencedPackages = new HashSet<EPackage>();
        for (EPackage ePackage : ePackages) {
            allReferencedPackages.add(ePackage);
            Set referencedPackages = ModelUtils.computeReferencedPackages((EPackage)ePackage);
            allReferencedPackages.addAll(referencedPackages);
        }
        block1: for (MetamodelView metamodelView : allCustomizations) {
            String nsURI = metamodelView.getMetamodelURI();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            while (ePackage != null) {
                if (allReferencedPackages.contains(ePackage)) {
                    filteredCustomizations.add(metamodelView);
                    continue block1;
                }
                if (ePackage instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)ePackage;
                    ePackage = facetSet.getExtendedPackage();
                    continue;
                }
                ePackage = ePackage.getESuperPackage();
            }
        }
        return filteredCustomizations;
    }
}

