/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.clipboard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

public class JavaInfoMementoTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "DESIGNER_TYPE_NAME";
    private static final int TYPE_ID = JavaInfoMementoTransfer.registerType((String)"DESIGNER_TYPE_NAME");
    private static JavaInfoMementoTransfer _instance = new JavaInfoMementoTransfer();

    private JavaInfoMementoTransfer() {
    }

    public static JavaInfoMementoTransfer getInstance() {
        return _instance;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    public void javaToNative(final Object object, final TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    byte[] bytes = JavaInfoMementoTransfer.convertObjectToBytes(object);
                    JavaInfoMementoTransfer.super.javaToNative(bytes, transferData);
                }
            });
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            return ExecutionUtils.runObject(() -> {
                byte[] bytes = (byte[])JavaInfoMementoTransfer.super.nativeToJava(transferData);
                return JavaInfoMementoTransfer.convertBytesToObject(bytes);
            });
        }
        return null;
    }

    public static byte[] convertObjectToBytes(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
        oos.writeObject(object);
        oos.close();
        return baos.toByteArray();
    }

    public static Object convertBytesToObject(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (BundleObjectInputStream ois = new BundleObjectInputStream(new GZIPInputStream(bais));){
            Object object = ois.readObject();
            return object;
        }
    }

    private static final class BundleObjectInputStream
    extends ObjectInputStream {
        public BundleObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            return ExternalFactoriesHelper.loadBundleClass((String)className);
        }
    }
}

