/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema.catalog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.internal.schema.catalog.Catalog;

public class CatalogSet {
    protected Map uriResourceMap = new HashMap();
    protected Map catalogPersistenceLocations = new HashMap();

    public Catalog lookupOrCreateCatalog(String id, String uri) {
        Catalog catalog = this.getCatalog(id, uri);
        if (catalog == null) {
            catalog = new Catalog(this, id, uri);
            try {
                catalog.load();
                this.uriResourceMap.put(uri, catalog);
            }
            catch (Exception e) {
                Logger.logException("error loading catalog: " + id + " " + uri, e);
            }
        }
        return catalog;
    }

    private Catalog getCatalog(String id, String uri) {
        return (Catalog)this.uriResourceMap.get(uri);
    }

    public void putCatalogPersistenceLocation(String logicalURI, String actualURI) {
        this.catalogPersistenceLocations.put(logicalURI, actualURI);
    }

    public String getCatalogPersistenceLocation(String id) {
        return (String)this.catalogPersistenceLocations.get(id);
    }

    public void clearResourceCache() {
        this.uriResourceMap.clear();
    }
}

