/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogParameter;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ExtendedOptions;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelFactory;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Source;
import org.eclipse.datatools.enablement.ibm.db2.model.impl.DB2UserDefinedFunctionImpl;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogUserDefinedFunction
extends DB2UserDefinedFunctionImpl
implements ICatalogObject,
IDatabaseObject {
    private static final long serialVersionUID = -9150711511025438670L;
    private static final String PROP_UDF_VALUES = "PROP_UDF_VALUES";
    private boolean dependencyLoaded = false;
    private boolean parameterLoaded = false;
    private byte luwFunctionType = 0;
    private boolean loaded = false;
    private boolean privilegeLoaded = false;
    private boolean statisticsLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();

    public void refresh() {
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        if (this.parameterLoaded) {
            this.parameters.clear();
            this.parameterLoaded = false;
        }
        this.privilegeLoaded = false;
        if (this.loaded) {
            this.extendedOptions.clear();
            this.loaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
        }
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public EList getParameters() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getParameters();
        }
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    public RoutineResultTable getReturnTable() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.returnTable;
    }

    public Parameter getReturnScalar() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.returnScalar;
    }

    public Parameter getReturnCast() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.returnCast;
    }

    public boolean isExternalAction() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.isExternalAction();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.isExternalAction();
    }

    public Source getSource() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getSource();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.getSource();
    }

    public DataAccess getSqlDataAccess() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getSqlDataAccess();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.getSqlDataAccess();
    }

    public String getLanguage() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getLanguage();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.getLanguage();
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public EList getExtendedOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getExtendedOptions();
        }
        if (!this.loaded) {
            this.load();
        }
        return this.extendedOptions;
    }

    public String getExternalName() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getExternalName();
        }
        if (!this.loaded) {
            this.load();
        }
        return this.externalName;
    }

    public boolean isImplicitSchema() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.isImplicitSchema();
        }
        if (!this.loaded) {
            this.load();
        }
        return this.implicitSchema;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogProcedure.getStatistics(this.getConnection(), (Routine)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 2) {
            this.getDependencies();
        } else if (id == 18) {
            this.getParameters();
        } else if (id == 26) {
            this.getReturnTable();
        } else if (id == 27) {
            this.getReturnScalar();
        } else if (id == 28) {
            this.getReturnCast();
        } else if (id == 7) {
            this.getPrivileges();
        } else if (id == 41) {
            this.getExtendedOptions();
        } else if (id == 17) {
            this.getExternalName();
        }
        return super.eIsSet(eFeature);
    }

    public byte getLUWFunctionType() {
        return this.luwFunctionType;
    }

    public void setLUWFunctionType(byte type) {
        this.luwFunctionType = type;
    }

    private synchronized void load() {
        boolean deliver;
        block26: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            this.getCatalogDatabase();
            String cfr_ignored_0 = String.valueOf(this.getSchema().getName()) + "." + this.getName();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            super.getExtendedOptions();
            Connection connection = this.getConnection();
            DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
            String version = definition.getVersion();
            float ver = 8.0f;
            try {
                ver = Float.parseFloat(version.substring(1));
            }
            catch (NumberFormatException numberFormatException) {}
            String query = null;
            query = ver < 8.0f ? "SELECT LANGUAGE, CASE VARIANT WHEN 'Y' THEN 'N' WHEN 'N' THEN 'Y' END AS DETERMINISTIC, SIDE_EFFECTS AS EXTERNAL_ACTION, CONTAINS_SQL AS SQL_DATA_ACCESS, TYPE AS FUNCTIONTYPE, BODY AS TEXT,PARALLELIZABLE AS PARALLEL, '' AS DEBUG_MODE,'' AS IMPLEMENTATION, '' AS CLASS, FUNCSCHEMA, FUNCNAME, SPECIFICNAME FROM SYSCAT.FUNCTIONS" : "SELECT LANGUAGE, DETERMINISTIC, SQL_DATA_ACCESS, EXTERNAL_ACTION, FUNCTIONTYPE, TEXT, PARALLEL, DEBUG_MODE,IMPLEMENTATION, CLASS, ROUTINESCHEMA AS FUNCSCHEMA, ROUTINENAME AS FUNCNAME, SPECIFICNAME FROM SYSCAT.ROUTINES";
            Statement s = null;
            ResultSet r = null;
            try {
                try {
                    s = connection.createStatement();
                    r = s.executeQuery(query);
                    while (r.next()) {
                        LoadInfo info = new LoadInfo();
                        info.schemaname = r.getString("FUNCSCHEMA").trim();
                        info.funcname = r.getString("FUNCNAME").trim();
                        info.DETERMINISTIC = r.getString("DETERMINISTIC");
                        info.SQL_DATA_ACCESS = r.getString("SQL_DATA_ACCESS");
                        info.EXTERNAL_ACTION = r.getString("EXTERNAL_ACTION");
                        info.FUNCTIONTYPE = r.getString("FUNCTIONTYPE");
                        info.TEXT = r.getString("TEXT");
                        info.PARALLEL = r.getString("PARALLEL");
                        info.DEBUG_MODE = r.getString("DEBUG_MODE");
                        info.IMPLEMENTATION = r.getString("IMPLEMENTATION");
                        info.CLASS = r.getString("CLASS");
                        info.setValues(this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (SQLException sQLException) {}
                        r = null;
                    }
                    if (s == null) break block26;
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                    s = null;
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (SQLException sQLException) {}
                    r = null;
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                    s = null;
                }
                throw throwable;
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {}
                r = null;
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
                s = null;
            }
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadDependencies(this.getConnection(), super.getDependencies(), (Routine)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        this.parameterLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogUserDefinedFunction.loadParameters(this.getConnection(), super.getParameters(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadPrivileges(this.getConnection(), privileges, (Routine)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadParameters(Connection connection, EList parameterList, LUWCatalogUserDefinedFunction function) throws SQLException {
        block54: {
            Database database = function.getSchema().getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            String version = databaseDefinition.getVersion();
            float ver = 8.0f;
            try {
                ver = Float.parseFloat(version);
            }
            catch (NumberFormatException numberFormatException) {}
            String query = null;
            query = ver < 8.0f ? "SELECT PARMNAME,ROWTYPE,AS_LOCATOR AS LOCATOR,TYPESCHEMA,TYPENAME,LENGTH,SCALE,CODEPAGE, ' ' AS REMARKS,TARGET_TYPESCHEMA,TARGET_TYPENAME FROM SYSCAT.FUNCPARMS WHERE FUNCSCHEMA='" + LUWUtil.getIdentifier(function.getSchema().getName()) + "'" + " AND FUNCNAME='" + LUWUtil.getIdentifier(function.getName()) + "'" + " AND SPECIFICNAME='" + function.getSpecificName() + "'" + " ORDER BY ORDINAL" : "SELECT PARMNAME,ROWTYPE,LOCATOR,TYPESCHEMA,TYPENAME,LENGTH,SCALE,CODEPAGE,REMARKS,TARGET_TYPESCHEMA,TARGET_TYPENAME FROM SYSCAT.ROUTINEPARMS WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(function.getSchema().getName()) + "'" + " AND ROUTINENAME='" + LUWUtil.getIdentifier(function.getName()) + "'" + " AND SPECIFICNAME='" + function.getSpecificName() + "'" + " ORDER BY ORDINAL";
            Statement s = null;
            ResultSet r = null;
            try {
                try {
                    s = connection.createStatement();
                    r = s.executeQuery(query);
                    while (r.next()) {
                        String typeSchemaName;
                        PredefinedDataTypeDefinition typeDefinition;
                        boolean isTableFunction = false;
                        String name = r.getString("PARMNAME");
                        String rowtype = r.getString("ROWTYPE").trim();
                        if (rowtype.equals("R") && function.getLUWFunctionType() == 1) {
                            isTableFunction = true;
                        }
                        PredefinedDataType type = null;
                        String typeName = r.getString("TYPENAME");
                        if (typeName.equalsIgnoreCase("FLOAT")) {
                            int length = r.getInt("LENGTH");
                            typeName = length == 4 ? "REAL" : "DOUBLE";
                        }
                        if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName)) != null) {
                            EStructuralFeature feature;
                            int length;
                            int codePage;
                            if (typeDefinition.getPrimitiveType().getValue() == 0) {
                                int codePage2 = r.getInt("CODEPAGE");
                                if (codePage2 == 0) {
                                    typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                                }
                            } else if (typeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt("CODEPAGE")) == 0) {
                                typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                            }
                            type = databaseDefinition.getPredefinedDataType(typeDefinition);
                            if (typeDefinition.isLengthSupported()) {
                                length = r.getInt("LENGTH");
                                if (length == 0) {
                                    length = 1;
                                }
                                feature = type.eClass().getEStructuralFeature("length");
                                type.eSet(feature, (Object)length);
                            } else if (typeDefinition.isPrecisionSupported()) {
                                if (typeName.equals("TIMESTAMP")) {
                                    length = r.getInt("SCALE");
                                    feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                                    type.eSet(feature, (Object)length);
                                } else {
                                    length = r.getInt("LENGTH");
                                    if (typeName.equals("DECFLOAT")) {
                                        length = length == 8 ? 16 : 34;
                                    }
                                    feature = type.eClass().getEStructuralFeature("precision");
                                    type.eSet(feature, (Object)length);
                                }
                            }
                            if (typeDefinition.isScaleSupported()) {
                                length = r.getInt("SCALE");
                                feature = type.eClass().getEStructuralFeature("scale");
                                type.eSet(feature, (Object)length);
                            }
                        } else if (typeName.equals("REFERENCE")) {
                            typeSchemaName = r.getString("TARGET_TYPESCHEMA").trim();
                            String udtName = r.getString("TARGET_TYPENAME");
                            type = LUWCatalogProcedure.getUserDefinedType((Routine)function, typeSchemaName, udtName);
                        } else {
                            typeSchemaName = r.getString("TYPESCHEMA").trim();
                            type = LUWCatalogProcedure.getUserDefinedType((Routine)function, typeSchemaName, typeName);
                        }
                        if (isTableFunction) {
                            RoutineResultTable resultTable = function.getReturnTable();
                            if (resultTable == null) {
                                resultTable = (RoutineResultTable)factory.create(SQLRoutinesPackage.eINSTANCE.getRoutineResultTable());
                                function.setReturnTable(resultTable);
                            }
                            Column column = SQLTablesFactory.eINSTANCE.createColumn();
                            column.setName(name);
                            column.setDescription(r.getString("REMARKS"));
                            column.setDataType((DataType)type);
                            resultTable.getColumns().add((Object)column);
                            continue;
                        }
                        LUWCatalogParameter parameter = new LUWCatalogParameter();
                        parameter.setName(name);
                        if (rowtype.equals("B")) {
                            parameter.setMode(ParameterMode.INOUT_LITERAL);
                        } else if (rowtype.equals("O")) {
                            parameter.setMode(ParameterMode.OUT_LITERAL);
                        } else if (rowtype.equals("P")) {
                            parameter.setMode(ParameterMode.IN_LITERAL);
                        }
                        String locator = r.getString("LOCATOR");
                        if (locator.equals("Y")) {
                            parameter.setLocator(true);
                        } else {
                            parameter.setLocator(false);
                        }
                        parameter.setDescription(r.getString("REMARKS"));
                        parameter.setDataType((DataType)type);
                        if (rowtype.equals("C")) {
                            function.setReturnScalar((Parameter)parameter);
                            continue;
                        }
                        if (rowtype.equals("R")) {
                            function.setReturnCast((Parameter)parameter);
                            continue;
                        }
                        parameterList.add((Object)parameter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (SQLException sQLException) {}
                        r = null;
                    }
                    if (s == null) break block54;
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                    s = null;
                    break block54;
                }
            }
            catch (Throwable throwable) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (SQLException sQLException) {}
                    r = null;
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                    s = null;
                }
                throw throwable;
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {}
                r = null;
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
                s = null;
            }
        }
    }

    private void updateImplicitSchemaFlag() {
        String body;
        Source src;
        boolean b = false;
        if (this != null && !(b = this.isImplicitSchema()) && this.getLanguage().equalsIgnoreCase("SQL") && (src = this.getSource()) != null && (body = src.getBody()) != null) {
            String[] tokens = body.split(" ");
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].indexOf(46) > -1) break;
                if (tokens[i].indexOf(40) > -1) {
                    b = true;
                    break;
                }
                ++i;
            }
        }
        this.setImplicitSchema(b);
    }

    private void setJavaExternalName(String className, String imple) {
        if (className == null || imple == null) {
            return;
        }
        String exteranlName = String.valueOf(className) + ".";
        exteranlName = imple.indexOf("(") != -1 ? String.valueOf(exteranlName) + imple.substring(0, imple.indexOf("(")) : String.valueOf(exteranlName) + imple;
        this.externalName = exteranlName;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogProcedure.getImpactedTriggers(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedTables(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedConstraints(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedRoutines(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedPackages(connection, (Routine)this));
        return impacts;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadPrivileges(this.getConnection(), privileges, (Routine)this, granteeFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static interface FunctionTypeEnumeration {
        public static final byte SCALAR_FUNCTION = 0;
        public static final byte TABLE_FUNCTION = 1;
        public static final byte ROW_FUNCTION = 2;
        public static final byte COLUMN_FUNCTION = 3;
        public static final byte ENUMERATION_LENGTH = 4;
    }

    private static class LoadInfo {
        String schemaname;
        String funcname;
        String DETERMINISTIC;
        String SQL_DATA_ACCESS;
        String EXTERNAL_ACTION;
        String FUNCTIONTYPE;
        String TEXT;
        String PARALLEL;
        String DEBUG_MODE;
        String IMPLEMENTATION;
        String CLASS;

        private LoadInfo() {
        }

        public String getKey() {
            return String.valueOf(this.schemaname) + "." + this.funcname;
        }

        public void setValues(LUWCatalogUserDefinedFunction func) {
            func.setDeterministic(this.DETERMINISTIC.equals("Y"));
            func.setExternalAction(this.EXTERNAL_ACTION.equals("E"));
            func.setFunctionType(this.FUNCTIONTYPE);
            func.setAllowParallel("Y".equals(this.PARALLEL));
            DataAccess da = this.SQL_DATA_ACCESS.equals("C") ? DataAccess.CONTAINS_SQL_LITERAL : (this.SQL_DATA_ACCESS.equals("M") ? DataAccess.MODIFIES_SQL_DATA_LITERAL : (this.SQL_DATA_ACCESS.equals("N") ? DataAccess.NO_SQL_LITERAL : DataAccess.READS_SQL_DATA_LITERAL));
            func.setSqlDataAccess(da);
            if (this.TEXT != null) {
                this.TEXT = this.TEXT.replaceAll("[\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]", " ");
                DB2Source source = DB2ModelFactory.eINSTANCE.createDB2Source();
                source.setBody(this.TEXT);
                func.setSource((Source)source);
            }
            DB2ExtendedOptions extOpts = DB2ModelFactory.eINSTANCE.createDB2ExtendedOptions();
            extOpts.setForDebug("ALLOW".equalsIgnoreCase(this.DEBUG_MODE));
            EList extList = func.getExtendedOptions();
            extList.add((Object)extOpts);
            if ("JAVA".equals(func.getLanguage())) {
                func.setJavaExternalName(this.CLASS, this.IMPLEMENTATION);
            } else if (!"SQL".equals(func.getLanguage())) {
                func.setExternalName(this.IMPLEMENTATION);
            }
            func.updateImplicitSchemaFlag();
        }
    }
}

