/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class StringCache {
    private static int INITIAL_SIZE = 32768;
    private static Map<String, WeakReference<String>> stringCache = new WeakHashMap<String, WeakReference<String>>(INITIAL_SIZE);
    public static final String EMPTY = StringCache.getUniqueString("");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueString(String value) {
        if (value == null) {
            return value;
        }
        Map<String, WeakReference<String>> map = stringCache;
        synchronized (map) {
            String existing;
            WeakReference<String> existingRef = stringCache.get(value);
            String string = existing = existingRef != null ? (String)existingRef.get() : null;
            if (existing == null) {
                stringCache.put(value, new WeakReference<String>(value));
            } else if (value != existing) {
                value = existing;
            }
        }
        return value;
    }

    private StringCache() {
    }
}

