/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;

public class RegularEnumSetExtractor
extends FieldSizeArrayCollectionExtractor
implements IMapExtractor {
    public RegularEnumSetExtractor(String sizeField, String arrayField) {
        super(sizeField, arrayField);
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        Object o = coll.resolveValue(this.sizeField);
        if (o instanceof Number) {
            return Long.bitCount(((Number)o).longValue());
        }
        return null;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        Object o = coll.resolveValue(this.sizeField);
        long used = 0L;
        if (o instanceof Number) {
            used = ((Number)o).longValue();
        }
        ArrayInt arr = new ArrayInt();
        long[] referenceArray = this.extractEntries(coll).getReferenceArray();
        ISnapshot snapshot = coll.getSnapshot();
        int i = 0;
        while (i < referenceArray.length && used != 0L) {
            if (referenceArray[i] != 0L && (used & 1L) != 0L) {
                arr.add(snapshot.mapAddressToId(referenceArray[i]));
            }
            ++i;
        }
        return arr.toArray();
    }

    @Override
    public boolean hasCollisionRatio() {
        return true;
    }

    @Override
    public Double getCollisionRatio(IObject collection) throws SnapshotException {
        return 0.0;
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject collection) throws SnapshotException {
        final ISnapshot snapshot = collection.getSnapshot();
        final int[] ids = this.extractEntryIds(collection);
        return new Iterator<Map.Entry<IObject, IObject>>(){
            int ix = 0;

            @Override
            public boolean hasNext() {
                return this.ix < ids.length;
            }

            @Override
            public Map.Entry<IObject, IObject> next() {
                IObject o;
                try {
                    o = snapshot.getObject(ids[this.ix++]);
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
                return new Map.Entry<IObject, IObject>(){

                    @Override
                    public IObject getKey() {
                        return o;
                    }

                    @Override
                    public IObject getValue() {
                        return o;
                    }

                    @Override
                    public IObject setValue(IObject value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

