/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.handlers.AbstractFileContentRequestHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentResponse;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;

public class FileContentRequestCurrentHandler
extends AbstractFileContentRequestHandler {
    private static final String EXCLUDED_EXTENSION = "phar";
    private int reqID;
    private String lastFileName;
    private String encoding;
    private PHPDebugTarget debugTarget;
    private boolean isFirstFileToDebug = true;
    private FileContentRequest contentRequest;

    @Override
    public void handle(IDebugMessage request, PHPDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        this.contentRequest = (FileContentRequest)request;
        this.reqID = this.contentRequest.getID();
        this.lastFileName = this.contentRequest.getFileName();
        this.encoding = this.contentRequest.getTransferEncoding();
    }

    @Override
    public IDebugResponseMessage getResponseMessage() {
        FileContentResponse response = new FileContentResponse();
        response.setID(this.reqID);
        try {
            byte[] content = null;
            if (!this.lastFileName.endsWith(EXCLUDED_EXTENSION)) {
                if (this.isFirstFileToDebug && PHPDebugPlugin.isDummyFile(this.lastFileName)) {
                    content = this.getDummyContent();
                    this.debugTarget.getContextManager().addToResolveBlacklist(new VirtualPath(this.lastFileName), ResolveBlackList.Type.FILE);
                } else {
                    RemoteDebugger remoteDebugger = (RemoteDebugger)this.debugTarget.getRemoteDebugger();
                    String localPath = remoteDebugger.convertToLocalFilename(this.lastFileName);
                    if (localPath != null) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(localPath);
                        if (resource != null) {
                            IPath location = resource.getLocation();
                            if (location != null) {
                                content = this.getBytesFromURI(location.toFile().toURI());
                            } else if (resource.exists()) {
                                content = this.getBytesFromURI(resource.getLocationURI());
                            }
                        } else {
                            File file = new File(localPath);
                            if (file.exists()) {
                                content = this.getBytesFromURI(file.toURI());
                            }
                        }
                    }
                }
            }
            if (content == null) {
                content = new byte[]{};
            }
            this.setResponseContent(response, this.contentRequest, content);
        }
        catch (FileNotFoundException content) {
        }
        catch (NullPointerException content) {
        }
        catch (Throwable t) {
            Logger.logException("Fail to send the file content to the server", t);
        }
        this.isFirstFileToDebug = false;
        return response;
    }

    private String getDebugType() {
        String debugType = "";
        try {
            debugType = this.debugTarget.getLaunch().getLaunchConfiguration().getAttribute("php_debug_type", "");
        }
        catch (CoreException ce) {
            PHPDebugPlugin.log(ce);
        }
        return debugType;
    }

    private byte[] getDummyContent() {
        String originalFileName = "";
        try {
            ILaunchConfiguration launchConfiguration = this.debugTarget.getLaunch().getLaunchConfiguration();
            originalFileName = launchConfiguration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException launchConfiguration) {
            // empty catch block
        }
        StringBuilder contentBuf = new StringBuilder("<?php ");
        File originalFile = new File(originalFileName);
        if (!originalFileName.startsWith("\\\\") && originalFile.exists() && this.getDebugType().equals("php_exe_script_debug")) {
            String parentDirectory = originalFile.getParentFile().getAbsolutePath();
            if (parentDirectory.endsWith(":\\")) {
                parentDirectory = String.valueOf(parentDirectory) + "\\";
            }
            contentBuf.append("chdir('").append(parentDirectory).append("'); ");
        }
        originalFileName = originalFileName.replaceAll("\\\\", "\\\\\\\\");
        contentBuf.append("include('").append(originalFileName).append("'); ?>");
        String content = contentBuf.toString();
        if (this.encoding != null) {
            try {
                return content.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                Logger.logException("Failed to create dummy content in the '" + this.encoding + "' encoding. \nCreating with the default encoding.", e);
            }
        }
        return content.getBytes();
    }

    private byte[] getBytesFromURI(URI uri) throws Exception {
        IFileStore fileStore = EFS.getStore((URI)uri);
        IFileInfo fileInfo = fileStore.fetchInfo();
        long length = fileInfo.getLength();
        if (length > Integer.MAX_VALUE) {
            throw new Exception("The requested file '" + this.lastFileName + "' is too big");
        }
        byte[] bytes = new byte[(int)length];
        InputStream openInputStream = fileStore.openInputStream(0, null);
        DataInputStream in = new DataInputStream(openInputStream);
        in.readFully(bytes);
        in.close();
        return bytes;
    }
}

