/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.properties;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, final Object expectedValue) {
        if (receiver instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)receiver;
            if ("isAttached".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean isAttached = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IProcesses.ProcessContext pc = node.getProcessContext();
                        ISysMonitor.SysMonitorContext sc = node.getSysMonitorContext();
                        boolean attached = false;
                        if (pc != null) {
                            attached = pc.isAttached();
                        }
                        if (!attached && sc != null) {
                            attached = sc.getTracerPID() > 0L || "t".equals(sc.getState());
                        }
                        isAttached.set(attached);
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == isAttached.get();
            }
            if ("canAttach".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean canAttach = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (node.getProcessContext() != null) {
                            if (node.getProcessContext().getProperties().containsKey("CanAttach")) {
                                Boolean value = (Boolean)node.getProcessContext().getProperties().get("CanAttach");
                                canAttach.set(value != null && value != false);
                            } else {
                                ISysMonitor.SysMonitorContext sc = node.getSysMonitorContext();
                                if (sc != null && sc.getProperties().containsKey("ExeType")) {
                                    Object exeType = sc.getProperties().get("ExeType");
                                    canAttach.set(!Integer.valueOf(1).equals(exeType));
                                } else {
                                    canAttach.set(true);
                                }
                            }
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == canAttach.get();
            }
            if ("hasProcessContext".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean canAttach = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        canAttach.set(node.getProcessContext() != null);
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == canAttach.get();
            }
            if ("canTerminate".equals(property) && expectedValue instanceof Boolean) {
                final AtomicBoolean canTerminate = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (node.getProcessContext() != null) {
                            canTerminate.set(node.getProcessContext().canTerminate());
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return ((Boolean)expectedValue).booleanValue() == canTerminate.get();
            }
            if ("hasCapability".equals(property) && expectedValue instanceof String) {
                final AtomicBoolean hasCapability = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Map caps = (Map)node.getProperty("capabilities");
                        if (caps != null) {
                            hasCapability.set(caps.containsKey(expectedValue) && Boolean.parseBoolean(caps.get(expectedValue).toString()));
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                return hasCapability.get();
            }
        }
        return false;
    }
}

