/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.construction.basiclinear;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.util.OrderingCompareAgent;

public class OrderingHeuristics
implements Comparator<PConstraint> {
    private SubPlan plan;
    private IQueryMetaContext context;

    public OrderingHeuristics(SubPlan plan, IQueryMetaContext context) {
        this.plan = plan;
        this.context = context;
    }

    @Override
    public int compare(PConstraint o1, PConstraint o2) {
        return new OrderingCompareAgent<PConstraint>(o1, o2){

            @Override
            protected void doCompare() {
                boolean temp;
                boolean bl = temp = this.consider(1.preferTrue(OrderingHeuristics.this.isConstant((PConstraint)this.a), OrderingHeuristics.this.isConstant((PConstraint)this.b))) && this.consider(1.preferTrue(OrderingHeuristics.this.isReady((PConstraint)this.a), OrderingHeuristics.this.isReady((PConstraint)this.b)));
                if (!temp) {
                    return;
                }
                Set<PVariable> bound1 = OrderingHeuristics.this.boundVariables((PConstraint)this.a);
                Set<PVariable> bound2 = OrderingHeuristics.this.boundVariables((PConstraint)this.b);
                this.swallowBoolean(temp && this.consider(1.preferTrue(OrderingHeuristics.this.isBound((PConstraint)this.a, bound1), OrderingHeuristics.this.isBound((PConstraint)this.b, bound2))) && this.consider(1.preferMore(Integer.valueOf(OrderingHeuristics.this.degreeBound((PConstraint)this.a, bound1)), OrderingHeuristics.this.degreeBound((PConstraint)this.b, bound2))) && this.consider(1.preferLess(Integer.valueOf(OrderingHeuristics.this.degreeFree((PConstraint)this.a, bound1)), OrderingHeuristics.this.degreeFree((PConstraint)this.b, bound2))) && this.consider(1.preferLess(Integer.valueOf(((PConstraint)this.a).getMonotonousID()), ((PConstraint)this.b).getMonotonousID())) && this.consider(1.preferLess(Integer.valueOf(System.identityHashCode(this.a)), System.identityHashCode(this.b))));
            }
        }.compare();
    }

    boolean isConstant(PConstraint o) {
        return o instanceof ConstantValue;
    }

    boolean isReady(PConstraint o) {
        return o instanceof EnumerablePConstraint || o instanceof DeferredPConstraint && ((DeferredPConstraint)o).isReadyAt(this.plan, this.context);
    }

    Set<PVariable> boundVariables(PConstraint o) {
        Set boundVariables = CollectionsFactory.createSet((Collection)o.getAffectedVariables());
        boundVariables.retainAll(this.plan.getVisibleVariables());
        return boundVariables;
    }

    boolean isBound(PConstraint o, Set<PVariable> boundVariables) {
        return boundVariables.size() == o.getAffectedVariables().size();
    }

    int degreeBound(PConstraint o, Set<PVariable> boundVariables) {
        return boundVariables.size();
    }

    int degreeFree(PConstraint o, Set<PVariable> boundVariables) {
        return o.getAffectedVariables().size() - boundVariables.size();
    }
}

