/*******************************************************************************
 * Copyright (c) 2006, 2018 Wind River Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * Michael Scharf (Wind River) - initial API and implementation
 * Martin Oberhuber (Wind River) - fixed copyright headers and beautified
 *******************************************************************************/
package org.eclipse.tm.internal.terminal.control;

import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

/**
 * Provided by a view implementation.
 * @author Michael Scharf
 *
 */
public interface ITerminalListener {
	/**
	 * Called when the state of the connection has changed.
	 * @param state
	 */
	void setState(TerminalState state);

	/**
	 * @deprecated Migrate to implementing {@link ITerminalListener3} and
	 * override {@link ITerminalListener3#setTerminalTitle(String, String)
	 * @param title
	 */
	@Deprecated(forRemoval = true)
	void setTerminalTitle(String title);
}
