/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public abstract class AbstractRegExFunction
extends Function {
    protected static final String validflags = "smix";

    public AbstractRegExFunction(QName name, int arity) {
        super(name, arity);
    }

    public AbstractRegExFunction(QName name, int min_arity, int max_arity) {
        super(name, min_arity, max_arity);
    }

    protected static boolean matches(String pattern, String flags, String src) {
        boolean fnd = false;
        if (pattern.indexOf("-[") != -1) {
            pattern = pattern.replaceAll("\\-\\[", "&&[^");
        }
        Matcher m = AbstractRegExFunction.compileAndExecute(pattern, flags, src);
        while (m.find()) {
            fnd = true;
        }
        return fnd;
    }

    protected static Matcher regex(String pattern, String flags, String src) {
        Matcher matcher = AbstractRegExFunction.compileAndExecute(pattern, flags, src);
        return matcher;
    }

    private static Matcher compileAndExecute(String pattern, String flags, String src) {
        int flag = 1;
        if (flags != null) {
            if (flags.indexOf("m") >= 0) {
                flag |= 8;
            }
            if (flags.indexOf("s") >= 0) {
                flag |= 0x20;
            }
            if (flags.indexOf("i") >= 0) {
                flag |= 2;
            }
            if (flags.indexOf("x") >= 0) {
                flag |= 4;
            }
        }
        Pattern p = Pattern.compile(pattern, flag);
        return p.matcher(src);
    }
}

