/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.order;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.order.ComponentOrderBeforeSibling;
import org.eclipse.wb.internal.core.model.order.ComponentOrderDefault;
import org.eclipse.wb.internal.core.model.order.ComponentOrderFirst;
import org.eclipse.wb.internal.core.model.order.ComponentOrderLast;

public abstract class ComponentOrder {
    public static ComponentOrder parse(String specification) {
        if (specification.equals("default")) {
            return ComponentOrderDefault.INSTANCE;
        }
        if (specification.equals("last")) {
            return ComponentOrderLast.INSTANCE;
        }
        if (specification.equals("first")) {
            return ComponentOrderFirst.INSTANCE;
        }
        if (specification.startsWith("beforeSibling ")) {
            String nextComponentClass = specification.substring("beforeSibling ".length());
            return new ComponentOrderBeforeSibling(nextComponentClass);
        }
        throw new IllegalArgumentException("Unsupported order specification: " + specification);
    }

    public JavaInfo getNextComponent_whenLast(JavaInfo component, JavaInfo container) throws Exception {
        return null;
    }

    public boolean canBeBefore(JavaInfo otherComponent) {
        return true;
    }
}

