declare const _default: {
    $id: string;
    $schema: string;
    title: string;
    type: string[];
    properties: {
        definitions: {
            $comment: string;
            type: string;
            additionalProperties: {
                $ref: string;
            };
            default: {};
        };
        dependencies: {
            $comment: string;
            type: string;
            additionalProperties: {
                anyOf: {
                    $ref: string;
                }[];
            };
        };
        $id: {
            type: string;
            format: string;
            $comment: string;
            pattern: string;
        };
        $schema: {
            type: string;
            format: string;
        };
        $anchor: {
            type: string;
            pattern: string;
        };
        $ref: {
            type: string;
            format: string;
        };
        $dynamicRef: {
            type: string;
            format: string;
        };
        $vocabulary: {
            type: string;
            propertyNames: {
                type: string;
                format: string;
            };
            additionalProperties: {
                type: string;
            };
        };
        $comment: {
            type: string;
        };
        $defs: {
            type: string;
            additionalProperties: {
                $ref: string;
            };
            default: {};
        };
        prefixItems: {
            $ref: string;
        };
        items: {
            $ref: string;
        };
        contains: {
            $ref: string;
        };
        additionalProperties: {
            $ref: string;
        };
        properties: {
            type: string;
            additionalProperties: {
                $ref: string;
            };
            default: {};
        };
        patternProperties: {
            type: string;
            additionalProperties: {
                $ref: string;
            };
            propertyNames: {
                format: string;
            };
            default: {};
        };
        dependentSchemas: {
            type: string;
            additionalProperties: {
                $ref: string;
            };
        };
        propertyNames: {
            $ref: string;
        };
        if: {
            $ref: string;
        };
        then: {
            $ref: string;
        };
        else: {
            $ref: string;
        };
        allOf: {
            $ref: string;
        };
        anyOf: {
            $ref: string;
        };
        oneOf: {
            $ref: string;
        };
        not: {
            $ref: string;
        };
        unevaluatedItems: {
            $ref: string;
        };
        unevaluatedProperties: {
            $ref: string;
        };
        multipleOf: {
            type: string;
            exclusiveMinimum: number;
        };
        maximum: {
            type: string;
        };
        exclusiveMaximum: {
            type: string;
        };
        minimum: {
            type: string;
        };
        exclusiveMinimum: {
            type: string;
        };
        maxLength: {
            $ref: string;
        };
        minLength: {
            $ref: string;
        };
        pattern: {
            type: string;
            format: string;
        };
        maxItems: {
            $ref: string;
        };
        minItems: {
            $ref: string;
        };
        uniqueItems: {
            type: string;
            default: boolean;
        };
        maxContains: {
            $ref: string;
        };
        minContains: {
            $ref: string;
            default: number;
        };
        maxProperties: {
            $ref: string;
        };
        minProperties: {
            $ref: string;
        };
        required: {
            $ref: string;
        };
        dependentRequired: {
            type: string;
            additionalProperties: {
                $ref: string;
            };
        };
        const: boolean;
        enum: {
            type: string;
            items: boolean;
        };
        type: {
            anyOf: ({
                $ref: string;
                type?: undefined;
                items?: undefined;
                minItems?: undefined;
                uniqueItems?: undefined;
            } | {
                type: string;
                items: {
                    $ref: string;
                };
                minItems: number;
                uniqueItems: boolean;
                $ref?: undefined;
            })[];
        };
        title: {
            type: string;
        };
        description: {
            type: string;
        };
        default: boolean;
        deprecated: {
            type: string;
            default: boolean;
        };
        readOnly: {
            type: string;
            default: boolean;
        };
        writeOnly: {
            type: string;
            default: boolean;
        };
        examples: {
            type: string;
            items: boolean;
        };
        format: {
            type: string;
        };
        contentMediaType: {
            type: string;
        };
        contentEncoding: {
            type: string;
        };
        contentSchema: {
            $ref: string;
        };
    };
    $defs: {
        schemaArray: {
            type: string;
            minItems: number;
            items: {
                $ref: string;
            };
        };
        nonNegativeInteger: {
            type: string;
            minimum: number;
        };
        nonNegativeIntegerDefault0: {
            $ref: string;
            default: number;
        };
        simpleTypes: {
            enum: string[];
        };
        stringArray: {
            type: string;
            items: {
                type: string;
            };
            uniqueItems: boolean;
            default: any[];
        };
    };
};
export default _default;
