/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;

public class Strings {
    public final Pattern PLACE_HOLDER_NAME_EXTRACTOR_PATTERN = Pattern.compile("\\$\\{([\\w\\d\\.\\:\\-]*)\\}");
    public final Pattern PLACE_HOLDER_EXTRACTOR_PATTERN = Pattern.compile("(\\$\\{[\\w\\d\\.\\:\\-]*\\})");

    private Strings() {
    }

    public static Strings create() {
        return new Strings();
    }

    public String capitalizeFirstCharacter(String value) {
        return Character.toString(value.charAt(0)).toUpperCase() + value.substring(1, value.length());
    }

    public boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNotBlank(String str) {
        return !this.isBlank(str);
    }

    public boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public boolean isNotEmpty(String str) {
        return !this.isEmpty(str);
    }

    public boolean contains(String str, char searchChar) {
        if (this.isEmpty(str)) {
            return false;
        }
        return str.indexOf(searchChar) >= 0;
    }

    public String strip(String str, String stripChars) {
        if (this.isEmpty(str)) {
            return str;
        }
        str = this.stripStart(str, stripChars);
        return this.stripEnd(str, stripChars);
    }

    public String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public String lowerCaseFirstCharacter(String string) {
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public String replace(String text, Map<String, String> params) {
        AtomicReference<String> template = new AtomicReference<String>(text);
        params.forEach((key, value) -> template.set(((String)template.get()).replaceAll(key.replaceAll("\\$", "\\\\\\$").replaceAll("\\{", "\\\\\\{").replaceAll("\\}", "\\\\\\}"), (String)value)));
        return template.get();
    }

    public Map<Integer, List<String>> extractAllGroups(Pattern pattern, String target) {
        Matcher matcher = pattern.matcher(target);
        LinkedHashMap<Integer, List<String>> found = new LinkedHashMap<Integer, List<String>>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                try {
                    ArrayList<String> foundString = null;
                    foundString = (ArrayList<String>)found.get(i);
                    if (foundString == null) {
                        foundString = new ArrayList<String>();
                        found.put(i, foundString);
                    }
                    foundString.add(matcher.group(i));
                    continue;
                }
                catch (IndexOutOfBoundsException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "group " + i + " not found on string \"" + target + "\" using pattern " + pattern.pattern());
                }
            }
        }
        return found;
    }

    public String compile(String message, Object ... arguments) {
        for (Object obj : arguments) {
            message = message.replaceFirst("\\{\\}", Objects.isNull(obj) ? "null" : this.clear(obj.toString()));
        }
        return message;
    }

    private String clear(String text) {
        return text.replace("\\", "\\\\\\").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace(".", "\\.").replace("$", "\\$");
    }

    public String from(StackTraceElement[] stackTrace) {
        return this.from(stackTrace, '\t', 1);
    }

    public String from(StackTraceElement[] stackTrace, int marginCount) {
        return this.from(stackTrace, '\t', marginCount);
    }

    public String from(StackTraceElement[] stackTrace, char marginChar, int marginCount) {
        return this.from(Arrays.asList(stackTrace), marginChar, marginCount);
    }

    public String from(List<StackTraceElement> stackTrace) {
        return this.from(stackTrace, '\t', 1);
    }

    public String from(List<StackTraceElement> stackTrace, int marginCount) {
        return this.from(stackTrace, '\t', marginCount);
    }

    public String from(List<StackTraceElement> stackTrace, char marginChar, int marginCount) {
        if (stackTrace.isEmpty()) {
            return "";
        }
        String margin = new String(new char[marginCount]).replace('\u0000', marginChar);
        return "\n" + margin + "at " + String.join((CharSequence)("\n" + margin + "at "), stackTrace.stream().map(sTE -> sTE.toString()).collect(Collectors.toList()));
    }

    public String formatMessage(Throwable exc) {
        return exc.toString() + ": " + exc.getMessage();
    }

    public boolean areEquals(String string1, String string2) {
        return this.isEmpty(string1) && this.isEmpty(string2) || this.isNotEmpty(string1) && this.isNotEmpty(string2) && string1.equals(string2);
    }

    public String placeHolderToRegEx(String value) {
        return value.replace("$", "\\$").replace(".", "\\.").replace("{", "\\{").replace("}", "\\}");
    }

    public static class Paths {
        Function<String, String> pathCleaner;
        Function<String, String> uRLPathConverter;

        private Paths() {
            if (this.isWindowsOS()) {
                this.pathCleaner = path -> {
                    if ((path = path.replace("\\", "/")).startsWith("/")) {
                        path = path.substring(1);
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    return path.replaceAll("\\/{2,}", "/");
                };
                this.uRLPathConverter = this::convertURLPathToAbsolutePath0;
            } else {
                this.pathCleaner = path -> {
                    if ((path = path.replace("\\", "/").replaceAll("\\/{2,}", "/")).endsWith("/") && path.length() > 1) {
                        path = path.substring(0, path.length() - 1);
                    }
                    return path;
                };
                this.uRLPathConverter = this::convertURLPathToAbsolutePath1;
            }
        }

        private boolean isWindowsOS() {
            return StaticComponentContainer.SystemProperties.get("os.name", "generic").toLowerCase().contains("windows");
        }

        public static Paths create() {
            return new Paths();
        }

        public String clean(String path) {
            return this.pathCleaner.apply(path);
        }

        public String toSquaredPath(String absolutePath, boolean isFolder) {
            String root;
            String squaredPath = null;
            String string = root = absolutePath.indexOf("/") > 0 ? absolutePath.substring(0, absolutePath.indexOf(":")) : "root";
            if (absolutePath.chars().filter(ch -> ch == 47).count() > 1L) {
                if (isFolder) {
                    squaredPath = absolutePath.substring(absolutePath.indexOf("/")).replaceFirst("\\/", "\\[").replace("/", "][") + "]";
                } else {
                    squaredPath = absolutePath.substring(absolutePath.indexOf("/")).replaceFirst("\\/", "\\[").replace("/", "][");
                    squaredPath = squaredPath.substring(0, squaredPath.lastIndexOf("][") + 1) + squaredPath.substring(squaredPath.lastIndexOf("][") + 2);
                }
            } else {
                squaredPath = absolutePath.substring(absolutePath.indexOf("/") + 1);
                if (isFolder) {
                    squaredPath = "[" + squaredPath + "]";
                }
            }
            return "[" + root + "]" + squaredPath;
        }

        public String toNormalizedCleanedAbsolutePath(String path) {
            if ((path = this.clean(path)).chars().filter(ch -> ch == 47).count() == 0L || path.equals("/")) {
                return path;
            }
            return this.clean(java.nio.file.Paths.get(path, new String[0]).normalize().toAbsolutePath().toString());
        }

        public boolean isRoot(String path) {
            return (path = this.clean(path)).chars().filter(ch -> ch == 47).count() == 0L || path.equals("/");
        }

        public String getExtension(String path) {
            if (path.endsWith("/")) {
                return null;
            }
            if (path.contains("/")) {
                String name = path.substring(path.lastIndexOf("/") + 1);
                if (name.contains(".")) {
                    return name.substring(name.lastIndexOf(".") + 1);
                }
                return null;
            }
            return null;
        }

        public String convertURLPathToAbsolutePath(String inputURLPath) {
            return this.uRLPathConverter.apply(inputURLPath);
        }

        private String convertURLPathToAbsolutePath0(String inputURLPath) {
            String absolutePath = Executor.get(() -> URLDecoder.decode(inputURLPath, StandardCharsets.UTF_8.name()));
            absolutePath = this.removeInitialPathElements(absolutePath, "jar:", "zip:", "file:", "!");
            while (absolutePath.startsWith("/")) {
                absolutePath = absolutePath.substring(1);
            }
            if ((absolutePath = absolutePath.replaceAll("\\.(.*?)!\\/", "\\.$1\\/")).endsWith("/")) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            return absolutePath;
        }

        private String convertURLPathToAbsolutePath1(String inputURLPath) {
            String absolutePath = Executor.get(() -> URLDecoder.decode(inputURLPath, StandardCharsets.UTF_8.name()));
            absolutePath = this.removeInitialPathElements(absolutePath, "jar:", "zip:", "file:", "!");
            absolutePath = absolutePath.replaceAll("\\.(.*?)!\\/", "\\.$1\\/");
            return absolutePath;
        }

        public String removeInitialPathElements(String path, String ... toRemove) {
            if (toRemove != null && toRemove.length > 0) {
                for (String element : toRemove) {
                    if (!path.startsWith(element)) continue;
                    path = path.substring(path.indexOf(element) + element.length(), path.length());
                }
            }
            return path;
        }
    }
}

