/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;

class ResultExtensionUtil {
    static final String ATTR_UNBOUNDED_MAX_ARGS = "*";

    ResultExtensionUtil() {
    }

    static String getRequiredAttributeValue(IConfigurationElement element, String attributeName, String elementName) throws OdaException {
        String value = element.getAttribute(attributeName);
        if (value == null || value.length() == 0) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_EXT_POINT_ATTR_VALUE, (Object[])new Object[]{"org.eclipse.datatools.connectivity.oda.dynamicResultSet", element.getContributor().getName(), attributeName, elementName}));
        }
        return value;
    }

    static Integer getMinAttributeValue(IConfigurationElement element, String attributeName, Integer defaultValue) throws OdaException {
        String attrValueText = element.getAttribute(attributeName);
        if (attrValueText == null) {
            return defaultValue;
        }
        Integer minValue = null;
        try {
            minValue = Integer.valueOf(attrValueText);
        }
        catch (NumberFormatException numberFormatException) {}
        if (minValue == null || minValue < 0) {
            throw ResultExtensionUtil.newInvalidAttributeValueException(element.getContributor().getName(), attrValueText, attributeName);
        }
        return minValue;
    }

    static Integer getMaxAttributeValue(IConfigurationElement element, String attributeName, Integer defaultValue, Integer minValue) throws OdaException {
        String attrValueText = element.getAttribute(attributeName);
        if (attrValueText == null) {
            return defaultValue;
        }
        if (attrValueText.equals(ATTR_UNBOUNDED_MAX_ARGS)) {
            return null;
        }
        Integer maxValue = null;
        try {
            maxValue = Integer.valueOf(attrValueText);
        }
        catch (NumberFormatException numberFormatException) {}
        if (maxValue == null || maxValue < minValue) {
            throw ResultExtensionUtil.newInvalidAttributeValueException(element.getContributor().getName(), attrValueText, attributeName);
        }
        return maxValue;
    }

    static boolean getBooleanAttributeValue(IConfigurationElement element, String attributeName, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        String attrValueText = element.getAttribute(attributeName);
        if (attrValueText != null) {
            booleanValue = Boolean.parseBoolean(attrValueText);
        }
        return booleanValue;
    }

    static void validateArgumentExists(String arg) throws IllegalArgumentException {
        if (arg == null || arg.length() == 0) {
            throw new IllegalArgumentException(arg);
        }
    }

    static void validateArgumentExists(ExtensionContributor contributor) throws IllegalArgumentException {
        if (contributor == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
    }

    static void validateConfigurationElement(IConfigurationElement element) throws OdaException {
        if (element == null || !element.isValid()) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_EXT_POINT_ELEMENT, (Object)"org.eclipse.datatools.connectivity.oda.dynamicResultSet", (Object)element.getContributor().getName()));
        }
    }

    static OdaException newInvalidAttributeValueException(String extensionId, String attrValue, String attrName) {
        return new OdaException(Messages.bind((String)Messages.querySpec_INVALID_EXT_POINT_ATTR_VALUE, (Object[])new Object[]{"org.eclipse.datatools.connectivity.oda.dynamicResultSet", extensionId, attrValue, attrName}));
    }
}

