/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;

public class ClientUtil {
    public static final boolean DEBUG = false;
    public static String REGISTRYVALUE = "getRegistryValue";
    public static String DB2PATH = "getDB2Path";
    public static String JDKLEVEL = "getJdkLevel";
    public static String ORACLEPATH = "getOraclePath";
    public static String DB2CLIENTLEVEL = "getDB2ClientLevel";
    public static String DB2CLIENTVERSION = "getDB2ClientVersion";
    public static String DB2CLIENTRELEASE = "getDB2ClientRelease";
    public static String DB2CLIENTMODIFICATION = "getDB2ClientModification";
    public static String VEPATH = "getVEPath";
    public static String VELEVEL = "getVELevel";
    public static String VEVERSION = "getVEVersion";
    public static String VERELEASE = "getVERelease";
    public static String VEMODIFICATION = "getVEModification";
    public static String ALIASCOUNT = "getAliasCount";
    public static String ALIASES = "getAliases";
    public static String HOSTINFO = "getHostInfo";
    public static String ENVVAR = "getEnv";
    protected static HashMap defaultValues;
    protected static HashMap implMethods;
    protected static HashMap promptMethods;
    protected static HashMap actualValues;
    private static final String PATH_SEPARATOR;

    static {
        PATH_SEPARATOR = File.pathSeparator;
        ClientUtil.initDefaults();
    }

    protected static void initDefaults() {
        actualValues = new HashMap(37);
        defaultValues = new HashMap(37);
        implMethods = new HashMap(37);
        promptMethods = new HashMap(37);
        defaultValues.put(DB2PATH, "null");
    }

    public static Object getDefault(String methodname) {
        return defaultValues.get(methodname);
    }

    protected static Object callMethod(Method method) {
        return ClientUtil.callMethod(method, null, null);
    }

    protected static Object callMethod(Method method, Object instance, Object[] args) {
        Object rv = null;
        try {
            if (method != null) {
                boolean isStatic = Modifier.isStatic(method.getModifiers());
                if (instance != null || isStatic) {
                    rv = method.invoke(instance, args);
                }
            }
        }
        catch (NullPointerException isStatic) {
        }
        catch (IllegalAccessException isStatic) {
        }
        catch (InvocationTargetException ite) {
            String msg = ite.getMessage();
            if (msg == null) {
                Throwable te = ite.getTargetException();
                msg = String.valueOf(te.getClass().getName()) + ": " + te.getMessage();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return rv;
    }

    protected static Object getStoredValue(String methodname, Object[] args) {
        IBMPluginActivator plugin = IBMPluginActivator.getInstance();
        String returnString = null;
        if (plugin != null) {
            Preferences prefStore = plugin.getPluginPreferences();
            String prefKey = ClientUtil.getPrefKey(methodname, args);
            if (prefStore != null) {
                returnString = prefStore.getString(prefKey);
            }
        }
        return returnString;
    }

    protected static String getPrefKey(String methodname, Object[] args) {
        if (args != null) {
            StringBuffer prefKey = new StringBuffer();
            prefKey.append(methodname).append('(');
            int m = args.length;
            if (m > 0) {
                prefKey.append(args[0]);
                int a = 1;
                while (a < m) {
                    prefKey.append(',').append(args[a]);
                    ++a;
                }
            }
            prefKey.append(')');
            return prefKey.toString();
        }
        return methodname;
    }

    protected static Object getImplValue(String methodname) {
        Object value = null;
        Method m = (Method)implMethods.get(methodname);
        if (m != null) {
            value = ClientUtil.callMethod(m);
        }
        if (value == null && methodname.equalsIgnoreCase(DB2PATH)) {
            value = ClientUtil.getDB2PathJNI();
        }
        return value;
    }

    public static boolean fileExists(String file) {
        File f = new File(file);
        return f.exists();
    }

    public static synchronized String getDB2Path() {
        String value = (String)actualValues.get(DB2PATH);
        if (value == null) {
            value = (String)ClientUtil.getStoredValue(DB2PATH, null);
            if (value == null || value.length() == 0) {
                value = (String)ClientUtil.getImplValue(DB2PATH);
            }
            if (value == null || value.length() == 0) {
                value = (String)ClientUtil.getDefault(DB2PATH);
            }
            if (value == null || value.equals("null")) {
                value = null;
            } else {
                ClientUtil.setDB2Path(ClientUtil.cleanPath(value));
            }
        }
        if (value != null) {
            return ClientUtil.cleanPath(value);
        }
        return null;
    }

    protected static synchronized String cleanPath(String path) {
        int len;
        String slash = System.getProperty("file.separator");
        if (slash != null && slash.length() > 0 && (len = path.length()) > 0 && path.charAt(len - 1) == slash.charAt(0)) {
            return path.substring(0, len - 1);
        }
        return path;
    }

    public static synchronized boolean setDB2Path(String path) {
        if (!ClientUtil.fileExists(path = ClientUtil.cleanPath(path))) {
            actualValues.remove(DB2PATH);
            return false;
        }
        actualValues.put(DB2PATH, path);
        return true;
    }

    public static String getDB2PathJNI() {
        return null;
    }

    public static String getDB2zSeriesUniversalDriverClientJarsPath() {
        File licenseJar;
        File driverJar;
        StringBuffer db2DriverPath = new StringBuffer();
        StringBuffer db2zSeriesLicensePath = new StringBuffer();
        StringBuffer fullPath = new StringBuffer();
        db2DriverPath = new StringBuffer();
        db2zSeriesLicensePath = new StringBuffer();
        String path = null;
        try {
            path = FileLocator.resolve((URL)Platform.getBundle((String)"com.ibm.datatools.db2").getEntry("/")).getPath();
            db2DriverPath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc.jar");
            db2zSeriesLicensePath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc_license_cisuz.jar");
            driverJar = new File(db2DriverPath.toString());
            licenseJar = new File(db2zSeriesLicensePath.toString());
            if (driverJar.exists() && licenseJar.exists()) {
                fullPath.append(driverJar.getAbsolutePath()).append(PATH_SEPARATOR).append(licenseJar.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
        if (fullPath.toString().equals("") && (path = ClientUtil.getDB2Path()) != null && !path.equals("")) {
            db2DriverPath.append(path).append(File.separator).append("java").append(File.separator).append("db2jcc.jar");
            db2zSeriesLicensePath.append(path).append(File.separator).append("java").append(File.separator).append("db2jcc_license_cisuz.jar");
            driverJar = new File(db2DriverPath.toString());
            licenseJar = new File(db2zSeriesLicensePath.toString());
            if (driverJar.exists() && licenseJar.exists()) {
                fullPath.append(db2DriverPath.toString()).append(PATH_SEPARATOR).append(db2zSeriesLicensePath.toString());
            }
        }
        return fullPath.toString();
    }

    public static String getDB2zSeriesUniversalDriverJDBC4ClientJarsPath() {
        StringBuffer db2DriverPath = new StringBuffer();
        StringBuffer db2zSeriesLicensePath = new StringBuffer();
        StringBuffer fullPath = new StringBuffer();
        db2DriverPath = new StringBuffer();
        db2zSeriesLicensePath = new StringBuffer();
        String path = null;
        try {
            path = FileLocator.resolve((URL)Platform.getBundle((String)"com.ibm.datatools.db2").getEntry("/")).getPath();
            db2DriverPath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc4.jar");
            db2zSeriesLicensePath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc_license_cisuz.jar");
            File driverJar = new File(db2DriverPath.toString());
            File licenseJar = new File(db2zSeriesLicensePath.toString());
            if (driverJar.exists() && licenseJar.exists()) {
                fullPath.append(driverJar.getAbsolutePath()).append(PATH_SEPARATOR).append(licenseJar.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
        return fullPath.toString();
    }

    public static String getDB2iSeriesJT400ClientJarsPath() {
        try {
            String path = FileLocator.resolve((URL)Platform.getBundle((String)"com.ibm.datatools.db2.iseries").getEntry("driver/jt400.jar")).getPath();
            if (new File(path).exists()) {
                return new File(path).getAbsolutePath();
            }
            String db2Path = ClientUtil.getDB2Path();
            if (db2Path != null && !db2Path.equals("")) {
                StringBuffer db2DriverPath = new StringBuffer();
                db2DriverPath.append(db2Path).append(File.separator).append("tools").append(File.separator).append("jt400.jar");
                File driverJar = new File(db2DriverPath.toString());
                if (driverJar.exists()) {
                    return db2DriverPath.toString();
                }
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public static String getDB2UniversalDriverClientJarsPath() {
        File licenseJar;
        File driverJar;
        StringBuffer db2DriverPath = new StringBuffer();
        StringBuffer db2LicensePath = new StringBuffer();
        StringBuffer db2zSeriesLicensePath = new StringBuffer();
        StringBuffer fullPath = new StringBuffer();
        db2DriverPath = new StringBuffer();
        db2zSeriesLicensePath = new StringBuffer();
        String path = null;
        try {
            path = FileLocator.resolve((URL)Platform.getBundle((String)"com.ibm.datatools.db2").getEntry("/")).getPath();
            db2DriverPath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc.jar");
            db2zSeriesLicensePath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc_license_cisuz.jar");
            driverJar = new File(db2DriverPath.toString());
            licenseJar = new File(db2zSeriesLicensePath.toString());
            if (driverJar.exists() && licenseJar.exists()) {
                fullPath.append(driverJar.getAbsolutePath()).append(PATH_SEPARATOR).append(licenseJar.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
        if (fullPath.toString().equals("") && (path = ClientUtil.getDB2Path()) != null && !path.equals("")) {
            db2DriverPath.append(path).append(File.separator).append("java").append(File.separator).append("db2jcc.jar");
            db2LicensePath.append(path).append(File.separator).append("java").append(File.separator).append("db2jcc_license_cu.jar");
            db2zSeriesLicensePath.append(path).append(File.separator).append("java").append(File.separator).append("db2jcc_license_cisuz.jar");
            driverJar = new File(db2DriverPath.toString());
            licenseJar = new File(db2LicensePath.toString());
            File zSeriesLicenseJar = new File(db2zSeriesLicensePath.toString());
            if (driverJar.exists() && zSeriesLicenseJar.exists()) {
                fullPath.append(db2DriverPath.toString()).append(PATH_SEPARATOR).append(db2zSeriesLicensePath.toString());
            } else if (driverJar.exists() && licenseJar.exists()) {
                fullPath.append(db2DriverPath.toString()).append(PATH_SEPARATOR).append(db2LicensePath.toString());
            }
        }
        return fullPath.toString();
    }

    public static String getDB2UniversalDriverJDBC4ClientJarsPath() {
        StringBuffer db2DriverPath = new StringBuffer();
        StringBuffer db2zSeriesLicensePath = new StringBuffer();
        StringBuffer fullPath = new StringBuffer();
        db2DriverPath = new StringBuffer();
        db2zSeriesLicensePath = new StringBuffer();
        String path = null;
        try {
            path = FileLocator.resolve((URL)Platform.getBundle((String)"com.ibm.datatools.db2").getEntry("/")).getPath();
            db2DriverPath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc4.jar");
            db2zSeriesLicensePath.append(path).append(File.separator).append("driver").append(File.separator).append("db2jcc_license_cisuz.jar");
            File driverJar = new File(db2DriverPath.toString());
            File licenseJar = new File(db2zSeriesLicensePath.toString());
            if (driverJar.exists() && licenseJar.exists()) {
                fullPath.append(driverJar.getAbsolutePath()).append(PATH_SEPARATOR).append(licenseJar.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
        return fullPath.toString();
    }
}

