/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.VerifierRegistry;
import org.eclipse.wst.common.core.util.RegistryReader;

public class VerifierRegistryReader
extends RegistryReader {
    static final String ASSEMBLY_VERIFIER_EXTENSION_POINT = "deploymentAssemblyVerifier";
    static final String TARGET_SERVER_RUNTIME_ID = "runtime_server_id";
    static final String RUNTIME = "runtime";
    static final String VERIFIER = "verifier";
    public static final String VERIFIER_CLASS = "class";
    static final String COMPONENT_TYPE_ID = "component_type";
    static final String COMPONENT = "component";

    public VerifierRegistryReader() {
        super("org.eclipse.wst.common.modulecore.ui", ASSEMBLY_VERIFIER_EXTENSION_POINT);
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(VERIFIER)) {
            return false;
        }
        ArrayList<String> runtimeList = new ArrayList<String>();
        ArrayList<String> comps = new ArrayList<String>();
        IConfigurationElement[] runtimes = element.getChildren(RUNTIME);
        int i = 0;
        while (i < runtimes.length) {
            IConfigurationElement runtime = runtimes[i];
            String serverTarget = runtime.getAttribute(TARGET_SERVER_RUNTIME_ID);
            runtimeList.add(serverTarget);
            ++i;
        }
        IConfigurationElement[] components = element.getChildren(COMPONENT);
        int i2 = 0;
        while (i2 < components.length) {
            IConfigurationElement component = components[i2];
            String compType = component.getAttribute(COMPONENT_TYPE_ID);
            comps.add(compType);
            ++i2;
        }
        String deployer = element.getAttribute(VERIFIER_CLASS);
        if (deployer != null) {
            VerifierRegistry.instance().register(element, runtimeList, comps);
            return true;
        }
        return false;
    }
}

