/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskMigrator;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.ui.Messages;
import org.eclipse.mylyn.reviews.ui.ReviewCommentTaskAttachmentSource;
import org.eclipse.mylyn.reviews.ui.ReviewStatus;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public class CreateTask
extends Job {
    private TaskDataModel model;
    private Review review;
    private TaskRepository taskRepository;
    private AbstractRepositoryConnector connector;
    private String reviewer;

    public CreateTask(TaskDataModel model, Review review, String reviewer) {
        super(Messages.CreateTask_Title);
        this.model = model;
        this.review = review;
        this.taskRepository = model.getTaskRepository();
        this.connector = TasksUi.getRepositoryConnector((String)this.taskRepository.getConnectorKind());
        this.reviewer = reviewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            ITask newLocalTask = TasksUiUtil.createOutgoingNewTask((String)this.taskRepository.getConnectorKind(), (String)this.taskRepository.getRepositoryUrl());
            TaskAttributeMapper mapper = this.connector.getTaskDataHandler().getAttributeMapper(this.taskRepository);
            TaskData data = new TaskData(mapper, this.taskRepository.getConnectorKind(), this.taskRepository.getRepositoryUrl(), "");
            this.connector.getTaskDataHandler().initializeSubTaskData(this.taskRepository, data, this.model.getTaskData(), (IProgressMonitor)new NullProgressMonitor());
            if (this.reviewer != null && this.reviewer.isEmpty()) {
                this.createAttribute(data, "task.common.user.assigned", this.reviewer);
            }
            this.createAttribute(data, "task.common.summary", "Review of " + this.model.getTask().getTaskKey() + " " + this.model.getTask().getSummary());
            this.createAttribute(data, "task.common.component", this.model.getTaskData().getRoot().getMappedAttribute("task.common.component").getValue());
            this.createAttribute(data, "task.common.status", "NEW");
            this.createAttribute(data, "task.common.version", this.model.getTaskData().getRoot().getMappedAttribute("task.common.version").getValue());
            this.createAttribute(data, "task.common.product", this.model.getTaskData().getRoot().getMappedAttribute("task.common.product").getValue());
            byte[] attachmentBytes = this.createAttachment(this.model, this.review);
            SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskJob(this.connector, this.taskRepository, newLocalTask, data, new TreeSet());
            submitJob.schedule();
            submitJob.join();
            if (submitJob.getStatus() == null) {
                ITask newRepoTask = submitJob.getTask();
                TaskMigrator migrator = new TaskMigrator(newLocalTask);
                migrator.setDelete(true);
                migrator.execute(newRepoTask);
                TaskAttribute attachmentAttribute = data.getAttributeMapper().createTaskAttachment(data);
                try {
                    ReviewCommentTaskAttachmentSource attachment = new ReviewCommentTaskAttachmentSource(attachmentBytes);
                    monitor.subTask(Messages.CreateTask_UploadingAttachment);
                    this.connector.getTaskAttachmentHandler().postContent(this.taskRepository, newRepoTask, (AbstractTaskAttachmentSource)attachment, "review result", attachmentAttribute, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return new ReviewStatus(Messages.CreateTask_Success, newRepoTask);
            }
            return new Status(2, "org.eclipse.mylyn.reviews.ui", "");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.mylyn.reviews.ui", e.getMessage());
        }
    }

    private TaskAttribute createAttribute(TaskData taskData, String mappedAttributeName, String value) {
        TaskAttribute attribute = taskData.getRoot().createMappedAttribute(mappedAttributeName);
        attribute.setValue(value);
        return attribute;
    }

    private byte[] createAttachment(TaskDataModel model, Review review) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createFileURI((String)""));
            resource.getContents().add((Object)review);
            resource.getContents().add((Object)((EObject)review.getScope().get(0)));
            if (review.getResult() != null) {
                resource.getContents().add((Object)review.getResult());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream outputStream = new ZipOutputStream(byteArrayOutputStream);
            outputStream.putNextEntry(new ZipEntry("reviews-data.xml"));
            resource.save((OutputStream)outputStream, null);
            outputStream.closeEntry();
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

