/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.helper.Helper;

public class ListExpressionOperator
extends ExpressionOperator {
    protected String[] startStrings = null;
    protected String[] separators = null;
    protected String[] terminationStrings = null;
    protected boolean isComplete = false;
    protected boolean changed = false;

    @Override
    public ExpressionOperator clone() {
        ListExpressionOperator clone = new ListExpressionOperator();
        this.copyTo(clone);
        return clone;
    }

    @Override
    public void copyTo(ExpressionOperator operator) {
        super.copyTo(operator);
        if (operator == null) {
            return;
        }
        if (operator instanceof ListExpressionOperator) {
            ((ListExpressionOperator)operator).startStrings = Helper.copyStringArray(this.startStrings);
            ((ListExpressionOperator)operator).separators = Helper.copyStringArray(this.separators);
            ((ListExpressionOperator)operator).terminationStrings = Helper.copyStringArray(this.terminationStrings);
        }
    }

    @Override
    @Deprecated
    public String[] getDatabaseStrings() {
        return this.getDatabaseStrings(0);
    }

    @Override
    public String[] getDatabaseStrings(int arguments) {
        int i = 0;
        String[] databaseStrings = new String[arguments == 0 ? 2 : arguments + 1];
        int start = arguments < this.startStrings.length ? databaseStrings.length - 1 : this.startStrings.length;
        for (int j = 0; j < start; ++j) {
            databaseStrings[i] = this.startStrings[j];
            ++i;
        }
        int separ = (databaseStrings.length - start - 1) / this.separators.length;
        for (int j = 0; j < separ; ++j) {
            for (int k = 0; k < this.separators.length; ++k) {
                databaseStrings[i] = this.separators[k];
                ++i;
            }
        }
        int termi = databaseStrings.length - (start + separ * this.separators.length);
        for (int j = this.terminationStrings.length - termi; j < this.terminationStrings.length; ++j) {
            databaseStrings[i] = this.terminationStrings[j];
            ++i;
        }
        return databaseStrings;
    }

    public String[] getStartStrings() {
        return this.startStrings;
    }

    public void setStartString(String startString) {
        this.startStrings = new String[]{startString};
    }

    public void setStartStrings(String[] startStrings) {
        this.startStrings = startStrings;
    }

    public String[] getSeparators() {
        return this.separators;
    }

    public void setSeparator(String separator) {
        this.separators = new String[]{separator};
    }

    public void setSeparators(String[] separators) {
        this.separators = separators;
    }

    public String[] getTerminationStrings() {
        return this.terminationStrings;
    }

    public void setTerminationString(String terminationString) {
        this.terminationStrings = new String[]{terminationString};
    }

    public void setTerminationStrings(String[] terminationStrings) {
        this.terminationStrings = terminationStrings;
    }

    public void setIsComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }
}

