/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.rap.http.servlet.internal.Activator;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.DispatchTargets;
import org.eclipse.rap.http.servlet.internal.registration.PreprocessorRegistration;
import org.eclipse.rap.http.servlet.internal.servlet.HttpServletRequestWrapperImpl;
import org.eclipse.rap.http.servlet.internal.servlet.PreprocessorChainImpl;
import org.eclipse.rap.service.servlet.internal.whiteboard.Preprocessor;
import org.osgi.framework.ServiceReference;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    private HttpServiceRuntimeImpl httpServiceRuntimeImpl;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.unregisterHttpService(this);
        super.destroy();
    }

    public void setHttpServiceRuntimeImpl(HttpServiceRuntimeImpl httpServiceRuntimeImpl) {
        this.httpServiceRuntimeImpl = httpServiceRuntimeImpl;
    }

    public void sessionDestroyed(String sessionId) {
        this.httpServiceRuntimeImpl.sessionDestroyed(sessionId);
    }

    public void sessionIdChanged(String oldSessionId) {
        this.httpServiceRuntimeImpl.fireSessionIdChanged(oldSessionId);
    }

    private String getNotDecodedAlias(HttpServletRequest request) {
        String pathInfo = HttpServletRequestWrapperImpl.getDispatchPathInfo(request);
        if (pathInfo == null) {
            return null;
        }
        String requestUri = HttpServletRequestWrapperImpl.getDispatchRequestURI(request);
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        if (request.getDispatcherType() == DispatcherType.INCLUDE) {
            contextPath = (String)request.getAttribute("jakarta.servlet.include.context_path");
            servletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
        }
        return requestUri.substring(contextPath.length() + servletPath.length());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkRuntime();
        String alias = this.getNotDecodedAlias(request);
        if (alias == null) {
            alias = "/";
        }
        this.preprocess(request, response, alias, request.getDispatcherType());
    }

    /*
     * Unable to fully structure code
     */
    public void preprocess(HttpServletRequest request, HttpServletResponse response, String alias, DispatcherType dispatcherType) throws ServletException, IOException {
        registrations = this.httpServiceRuntimeImpl.getPreprocessorRegistrations();
        if (registrations.isEmpty()) {
            this.dispatch(request, response, alias, dispatcherType);
        } else {
            preprocessors = new CopyOnWriteArrayList<PreprocessorRegistration>();
            for (Map.Entry<ServiceReference<Preprocessor>, PreprocessorRegistration> entry : registrations.entrySet()) {
                registration = entry.getValue();
                preprocessors.add(registration);
                registration.addReference();
            }
            try {
                chain = new PreprocessorChainImpl(preprocessors, alias, dispatcherType, this);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                ** for (registration : preprocessors)
            }
lbl-1000:
            // 1 sources

            {
                registration.removeReference();
                continue;
            }
        }
lbl20:
        // 2 sources

    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, String alias, DispatcherType dispatcherType) throws ServletException, IOException {
        DispatchTargets dispatchTargets = this.httpServiceRuntimeImpl.getDispatchTargets(alias, null);
        if (dispatchTargets != null) {
            dispatchTargets.doDispatch(request, response, alias, dispatcherType);
            return;
        }
        response.sendError(404, "ProxyServlet: " + alias);
    }

    private void checkRuntime() {
        if (this.httpServiceRuntimeImpl == null) {
            throw new IllegalStateException("Proxy servlet not properly initialized. httpServiceRuntimeImpl is null");
        }
    }
}

