/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.internal;

import org.eclipse.rap.examples.IExampleContribution;
import org.eclipse.rap.examples.internal.ExampleCategory;
import org.eclipse.rap.examples.internal.Examples;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

abstract class DropDownNavigation
extends Composite {
    private final Menu pullDownMenu;
    private final ExampleCategory category;

    public DropDownNavigation(Composite parent, ExampleCategory category) {
        super(parent, 0);
        this.category = category;
        this.pullDownMenu = this.createMenu(parent);
        this.setLayout((Layout)new FillLayout());
        this.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.createMenuItems();
        this.createDropDownToolItem();
    }

    public ExampleCategory getCategory() {
        return this.category;
    }

    private Menu createMenu(Composite parent) {
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        menu.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        return menu;
    }

    private void createMenuItems() {
        for (String id : this.category.getContributionIds()) {
            IExampleContribution contribution = Examples.getInstance().getContribution(id);
            if (contribution == null) continue;
            this.createMenuItem(contribution);
        }
    }

    private void createMenuItem(final IExampleContribution contribution) {
        MenuItem item = new MenuItem(this.pullDownMenu, 16392);
        item.setText(contribution.getTitle().replace("&", "&&"));
        item.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DropDownNavigation.this.contributionSelected(contribution);
            }
        });
    }

    private void createDropDownToolItem() {
        final ToolBar toolBar = new ToolBar((Composite)this, 256);
        toolBar.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        toolItem.setText(this.category.getName().replace("&", "&&"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int yOffset = event.detail == 4 ? 0 : toolBar.getSize().y;
                DropDownNavigation.this.openMenu(toolBar.toDisplay(event.x, event.y + yOffset));
            }
        });
    }

    private void openMenu(Point point) {
        this.pullDownMenu.setLocation(point);
        this.pullDownMenu.setVisible(true);
    }

    protected abstract void contributionSelected(IExampleContribution var1);
}

