/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.lifecycle.IPhase;
import org.eclipse.rap.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rap.rwt.internal.lifecycle.ReadData;
import org.eclipse.rap.rwt.internal.lifecycle.Render;
import org.eclipse.rap.rwt.internal.lifecycle.UIThread;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushManager;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.widgets.Display;

public class RWTLifeCycle
extends LifeCycle {
    private static final Integer ZERO = 0;
    private static final String CURRENT_PHASE = RWTLifeCycle.class.getName() + ".currentPhase";
    private static final String PHASE_ORDER = RWTLifeCycle.class.getName() + ".phaseOrder";
    private static final String UI_THREAD_WAITING_FOR_TERMINATION = UIThreadController.class.getName() + "#UIThreadWaitingForTermination";
    private static final String UI_THREAD_THROWABLE = UIThreadController.class.getName() + "#UIThreadThrowable";
    private static final String REQUEST_THREAD_RUNNABLE = RWTLifeCycle.class.getName() + "#requestThreadRunnable";
    private static final IPhase[] PHASE_ORDER_STARTUP = new IPhase[]{new IPhase.IInterruptible(){

        @Override
        public PhaseId execute(Display display) throws IOException {
            return null;
        }

        @Override
        public PhaseId getPhaseId() {
            return PhaseId.PREPARE_UI_ROOT;
        }
    }, new Render()};
    private static final IPhase[] PHASE_ORDER_SUBSEQUENT = new IPhase[]{new IPhase(){

        @Override
        public PhaseId execute(Display display) throws IOException {
            return null;
        }

        @Override
        public PhaseId getPhaseId() {
            return PhaseId.PREPARE_UI_ROOT;
        }
    }, new ReadData(), new IPhase.IInterruptible(){

        @Override
        public PhaseId execute(Display display) throws IOException {
            new ProcessAction().execute(display);
            return null;
        }

        @Override
        public PhaseId getPhaseId() {
            return PhaseId.PROCESS_ACTION;
        }
    }, new Render()};
    Runnable uiRunnable = new UIThreadController();

    public RWTLifeCycle(ApplicationContextImpl applicationContext) {
        super(applicationContext);
    }

    @Override
    public void execute() throws IOException {
        if (LifeCycleUtil.isStartup()) {
            this.setPhaseOrder(PHASE_ORDER_STARTUP);
        } else {
            this.setPhaseOrder(PHASE_ORDER_SUBSEQUENT);
        }
        Runnable runnable = null;
        do {
            RWTLifeCycle.setRequestThreadRunnable(null);
            this.executeUIThread();
            runnable = RWTLifeCycle.getRequestThreadRunnable();
            if (runnable == null) continue;
            runnable.run();
        } while (runnable != null);
    }

    @Override
    public void requestThreadExec(Runnable runnable) {
        RWTLifeCycle.setRequestThreadRunnable(runnable);
        RWTLifeCycle.getUIThreadHolder().switchThread();
    }

    private static void setRequestThreadRunnable(Runnable runnable) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(REQUEST_THREAD_RUNNABLE, runnable);
    }

    private static Runnable getRequestThreadRunnable() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        return (Runnable)serviceStore.getAttribute(REQUEST_THREAD_RUNNABLE);
    }

    void continueLifeCycle() {
        int start = 0;
        IPhase[] phaseOrder = this.getPhaseOrder();
        if (phaseOrder != null) {
            Integer currentPhase = RWTLifeCycle.getCurrentPhase();
            if (currentPhase != null) {
                int phaseIndex = currentPhase;
                this.phaseListenerManager.notifyAfterPhase(phaseOrder[phaseIndex].getPhaseId(), this);
                start = currentPhase + 1;
            }
            boolean interrupted = false;
            int i = start;
            while (!interrupted && i < phaseOrder.length) {
                IPhase phase = phaseOrder[i];
                CurrentPhase.set(phase.getPhaseId());
                this.phaseListenerManager.notifyBeforePhase(phase.getPhaseId(), this);
                if (phase instanceof IPhase.IInterruptible) {
                    ServiceStore serviceStore = ContextProvider.getServiceStore();
                    serviceStore.setAttribute(CURRENT_PHASE, i);
                    interrupted = true;
                } else {
                    try {
                        phase.execute(LifeCycleUtil.getSessionDisplay());
                    }
                    catch (Throwable e) {
                        throw new PhaseExecutionError(e);
                    }
                    this.phaseListenerManager.notifyAfterPhase(phase.getPhaseId(), this);
                }
                ++i;
            }
            if (!interrupted) {
                ContextProvider.getServiceStore().setAttribute(CURRENT_PHASE, null);
            }
        }
    }

    int createUI() {
        int result = -1;
        if (ZERO.equals(RWTLifeCycle.getCurrentPhase()) && LifeCycleUtil.isStartup()) {
            EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
            HttpServletRequest request = ContextProvider.getRequest();
            EntryPointRegistration registration = entryPointManager.getEntryPointRegistration(request);
            EntryPoint entryPoint = registration.getFactory().create();
            result = entryPoint.createUI();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeUIThread() throws IOException {
        ServiceContext context = ContextProvider.getContext();
        UISession uiSession = ContextProvider.getUISession();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        if (uiThread == null) {
            uiThread = this.createUIThread();
            uiThread.setServiceContext(context);
            Object object = uiThread.getLock();
            synchronized (object) {
                uiThread.getThread().start();
                uiThread.switchThread();
            }
        } else {
            uiThread.setServiceContext(context);
            if (!Boolean.TRUE.equals(uiSession.getAttribute(UI_THREAD_WAITING_FOR_TERMINATION))) {
                uiThread.switchThread();
            }
        }
        if (!uiThread.getThread().isAlive()) {
            LifeCycleUtil.setUIThread(uiSession, null);
        }
        RWTLifeCycle.handleUIThreadException();
    }

    private static void handleUIThreadException() throws IOException {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        Throwable throwable = (Throwable)serviceStore.getAttribute(UI_THREAD_THROWABLE);
        if (throwable != null) {
            if (throwable instanceof PhaseExecutionError) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void sleep() {
        this.continueLifeCycle();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        ServerPushManager.getInstance().notifyUIThreadEnd();
        uiThread.switchThread();
        uiThread.updateServiceContext();
        ServerPushManager.getInstance().notifyUIThreadStart();
        this.continueLifeCycle();
    }

    private IUIThreadHolder createUIThread() {
        UISession uiSession = ContextProvider.getUISession();
        UIThread result = new UIThread(this.uiRunnable);
        result.getThread().setDaemon(true);
        result.getThread().setName("UIThread [" + uiSession.getId() + "]");
        LifeCycleUtil.setUIThread(uiSession, result);
        RWTLifeCycle.setShutdownAdapter(result);
        return result;
    }

    private static Integer getCurrentPhase() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        return (Integer)serviceStore.getAttribute(CURRENT_PHASE);
    }

    private static void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        UISession uiSession = ContextProvider.getUISession();
        UISessionImpl uiSessionImpl = (UISessionImpl)uiSession;
        uiSessionImpl.setShutdownAdapter(adapter);
    }

    public void setPhaseOrder(IPhase[] phaseOrder) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(PHASE_ORDER, phaseOrder);
    }

    IPhase[] getPhaseOrder() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        return (IPhase[])serviceStore.getAttribute(PHASE_ORDER);
    }

    public static IUIThreadHolder getUIThreadHolder() {
        return LifeCycleUtil.getUIThread(ContextProvider.getUISession());
    }

    private static final class PhaseExecutionError
    extends ThreadDeath {
        public PhaseExecutionError(Throwable cause) {
            this.initCause(cause);
        }
    }

    private final class UIThreadController
    implements Runnable {
        private UIThreadController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IUIThreadHolder uiThread = (IUIThreadHolder)((Object)Thread.currentThread());
            try {
                Object object = uiThread.getLock();
                synchronized (object) {
                    try {
                        uiThread.updateServiceContext();
                        ServerPushManager.getInstance().notifyUIThreadStart();
                        RWTLifeCycle.this.continueLifeCycle();
                        RWTLifeCycle.this.createUI();
                        RWTLifeCycle.this.continueLifeCycle();
                        ServerPushManager.getInstance().notifyUIThreadEnd();
                    }
                    catch (UIThread.UIThreadTerminatedError thr) {
                        throw thr;
                    }
                    catch (Throwable thr) {
                        ServiceStore serviceStore = ContextProvider.getServiceStore();
                        serviceStore.setAttribute(UI_THREAD_THROWABLE, thr);
                    }
                    UISession uiSession = ContextProvider.getUISession();
                    uiSession.setAttribute(UI_THREAD_WAITING_FOR_TERMINATION, Boolean.TRUE);
                    uiThread.switchThread();
                }
            }
            catch (UIThread.UIThreadTerminatedError uIThreadTerminatedError) {
                ((ISessionShutdownAdapter)((Object)uiThread)).processShutdown();
            }
        }
    }
}

