/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    protected int targetOffset = 0;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class<?>[] paramTypes = null;
    protected String[] paramClassNames = null;
    protected boolean useExactMatch = false;

    public CallMethodRule(String methodName, int paramCount) {
        this(0, methodName, paramCount);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramCount == 0) {
            this.paramTypes = new Class[]{String.class};
        } else {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = String.class;
                ++i;
            }
        }
    }

    public CallMethodRule(String methodName) {
        this(0, methodName, 0, (Class<?>[])null);
    }

    public CallMethodRule(int targetOffset, String methodName) {
        this(targetOffset, methodName, 0, (Class<?>[])null);
    }

    public CallMethodRule(String methodName, int paramCount, String[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, String[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramClassNames = new String[paramTypes.length];
            int i = 0;
            while (i < this.paramClassNames.length) {
                this.paramClassNames[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public CallMethodRule(String methodName, int paramCount, Class<?>[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, Class<?>[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    @Override
    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            int i = 0;
            while (i < this.paramClassNames.length) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(this.paramClassNames[i]);
                }
                catch (ClassNotFoundException e) {
                    digester.getLogger().error("(CallMethodRule) Cannot load class " + this.paramClassNames[i], e);
                    this.paramTypes[i] = null;
                }
                ++i;
            }
        }
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] parameters = new Object[this.paramCount];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = null;
                ++i;
            }
            this.digester.pushParams(parameters);
        }
    }

    @Override
    public void body(String namespace, String name, String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText.trim();
        }
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        Object[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (Object[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                int i = 0;
                int size = parameters.length;
                while (i < size) {
                    this.digester.log.trace("[CallMethodRule](" + i + ")" + parameters[i]);
                    ++i;
                }
            }
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            parameters = new Object[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            paramValues[i] = parameters[i] == null || parameters[i] instanceof String && !String.class.isAssignableFrom(this.paramTypes[i]) ? IntrospectionUtils.convert((String)parameters[i], this.paramTypes[i]) : parameters[i];
            ++i;
        }
        Object target = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call target is null (");
            sb.append("targetOffset=");
            sb.append(this.targetOffset);
            sb.append(",stackdepth=");
            sb.append(this.digester.getCount());
            sb.append(")");
            throw new SAXException(sb.toString());
        }
        if (this.digester.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call ");
            sb.append(target.getClass().getName());
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            int i2 = 0;
            while (i2 < paramValues.length) {
                if (i2 > 0) {
                    sb.append(",");
                }
                if (paramValues[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i2].toString());
                }
                sb.append("/");
                if (this.paramTypes[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.paramTypes[i2].getName());
                }
                ++i2;
            }
            sb.append(")");
            this.digester.log.debug(sb.toString());
        }
        Object result = IntrospectionUtils.callMethodN(target, this.methodName, paramValues, this.paramTypes);
        this.processMethodCallResult(result);
    }

    @Override
    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object result) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramCount=");
        sb.append(this.paramCount);
        sb.append(", paramTypes={");
        if (this.paramTypes != null) {
            int i = 0;
            while (i < this.paramTypes.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.paramTypes[i].getName());
                ++i;
            }
        }
        sb.append("}");
        sb.append("]");
        return sb.toString();
    }
}

