/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.utils;

import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.server.backend.internal.SiriusServerBackendPlugin;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class SiriusServerUtils {
    public static final String UTF_8 = "UTF-8";

    private SiriusServerUtils() {
    }

    public static Session getSession(ModelingProject modelingProject) {
        Optional<Session> optionalSession = Optional.ofNullable(modelingProject.getSession());
        Session session = optionalSession.orElseGet(() -> {
            URI sessionResourceURI = (URI)modelingProject.getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor()).get();
            return SessionManager.INSTANCE.openSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor(), SiriusPlugin.getDefault().getUiCallback());
        });
        return session;
    }

    public static String getProjectDescription(IProject iProject) {
        String description = null;
        try {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String comment = iProjectDescription.getComment();
            if (comment != null && comment.trim().length() > 0) {
                description = comment;
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.sirius.server.backend", e.getMessage(), (Throwable)e);
            SiriusServerBackendPlugin.getPlugin().log(status);
        }
        return description;
    }
}

