/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.api;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.sirius.server.api.SiriusServerResponse;

public interface ISiriusServerService {
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    public static final String OPTIONS = "OPTIONS";

    default public SiriusServerResponse process(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        Optional<Object> optionalResponse = Optional.empty();
        switch (request.getMethod()) {
            case "GET": {
                optionalResponse = Optional.ofNullable(this.doGet(request, variables, remainingPart));
                break;
            }
            case "HEAD": {
                optionalResponse = Optional.ofNullable(this.doHead(request, variables, remainingPart));
                break;
            }
            case "PUT": {
                optionalResponse = Optional.ofNullable(this.doPut(request, variables, remainingPart));
                break;
            }
            case "POST": {
                optionalResponse = Optional.ofNullable(this.doPost(request, variables, remainingPart));
                break;
            }
            case "DELETE": {
                optionalResponse = Optional.ofNullable(this.doDelete(request, variables, remainingPart));
                break;
            }
            case "OPTIONS": {
                optionalResponse = Optional.ofNullable(this.doOptions(request, variables, remainingPart));
                break;
            }
            default: {
                optionalResponse = Optional.ofNullable(this.doError(request, variables, remainingPart));
            }
        }
        return optionalResponse.orElseGet(() -> this.doError(request, variables, remainingPart));
    }

    default public SiriusServerResponse doGet(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return null;
    }

    default public SiriusServerResponse doHead(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return null;
    }

    default public SiriusServerResponse doPut(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return null;
    }

    default public SiriusServerResponse doPost(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return null;
    }

    default public SiriusServerResponse doDelete(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return null;
    }

    default public SiriusServerResponse doOptions(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return null;
    }

    default public SiriusServerResponse doError(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return new SiriusServerResponse(400);
    }
}

