/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.image.refresh;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.ext.base.Option;

public class WorkspaceImageChangeDetector
implements IResourceDeltaVisitor {
    private boolean workspaceImageChangeDetected;

    public boolean visit(IResourceDelta delta) throws CoreException {
        boolean continueToVisit = true;
        boolean isWorkspaceImageChange = false;
        IResource resource = delta.getResource();
        if (this.isWorkspaceImage(resource)) {
            switch (delta.getKind()) {
                case 1: {
                    isWorkspaceImageChange = true;
                    break;
                }
                case 2: 
                case 4: {
                    isWorkspaceImageChange = this.needClearCache(delta.getResource());
                    break;
                }
            }
            this.workspaceImageChangeDetected = this.workspaceImageChangeDetected || isWorkspaceImageChange;
            continueToVisit = !this.workspaceImageChangeDetected;
        }
        return continueToVisit;
    }

    private boolean isWorkspaceImage(IResource resource) {
        boolean isWorkspaceImage = resource != null && resource.getType() == 1 && resource.getFileExtension() != null && this.isSupportedImageFormat(resource.getFileExtension());
        return isWorkspaceImage;
    }

    private boolean isSupportedImageFormat(String fileExtension) {
        boolean isSupportedImageFormat = false;
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.VALUES;
        int n = ImageFileFormat.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().toLowerCase().equals(fileExtension.toLowerCase())) {
                isSupportedImageFormat = true;
                break;
            }
            ++n2;
        }
        return isSupportedImageFormat;
    }

    public boolean isAtLeastOneEditorToRefresh() {
        return this.workspaceImageChangeDetected;
    }

    private boolean needClearCache(IResource resource) {
        boolean cacheUpdated = false;
        String resourceExtension = resource.getFileExtension();
        if (WorkspaceImageFigure.isSvgImage(resourceExtension)) {
            String svgUri = resource.getFullPath().toString();
            Option<String> removed = SVGWorkspaceImageFigure.removeFromCache(svgUri);
            if (removed.some()) {
                cacheUpdated = true;
            }
        } else {
            URL url;
            try {
                url = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(resource.getFullPath()).toOSString()).toURI().toURL();
            }
            catch (MalformedURLException e) {
                DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.WorkspaceImageChangeDetector_invalidUri, e.getMessage()));
                return false;
            }
            ImageDescriptor bundledImageDescriptor = ImageDescriptor.createFromURL((URL)url);
            boolean removed = DiagramUIPlugin.getPlugin().removeCacheImage(bundledImageDescriptor);
            if (removed) {
                cacheUpdated = true;
            }
        }
        return cacheUpdated;
    }
}

