/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.policies;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.internal.command.ViewDeleteCommand;

public class SiriusComponentEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(this.getEditingDomain(), "");
        List toDel = deleteRequest.getEditParts();
        if (toDel == null || toDel.isEmpty()) {
            cc.compose((IUndoableOperation)new ViewDeleteCommand(editingDomain, (View)this.getHost().getModel()));
        } else {
            for (IGraphicalEditPart gep : Iterables.filter((Iterable)toDel, IGraphicalEditPart.class)) {
                cc.compose((IUndoableOperation)new ViewDeleteCommand(editingDomain, (View)gep.getModel()));
            }
        }
        return new ICommandProxy(cc.reduce());
    }

    private TransactionalEditingDomain getEditingDomain() {
        EditingDomain domain;
        if (this.getHost() instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        }
        if (this.getHost() instanceof IEditingDomainProvider && (domain = ((IEditingDomainProvider)this.getHost()).getEditingDomain()) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }
}

