/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.converter;

import java.util.Optional;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramImageNode;
import org.eclipse.sirius.services.diagram.internal.SiriusDiagramPlugin;
import org.eclipse.sirius.services.diagram.internal.converter.AbstractSiriusDiagramNodeConverter;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;

public class SiriusDiagramImageNodeConverter
extends AbstractSiriusDiagramNodeConverter {
    private DNode dNode;

    public SiriusDiagramImageNodeConverter(DNode dNode) {
        this.dNode = dNode;
    }

    @Override
    protected AbstractDNode getDNode() {
        return this.dNode;
    }

    @Override
    public Optional<AbstractSiriusDiagramElement> convert() {
        Optional<WorkspaceImage> optionalStyle = Optional.of(this.dNode.getStyle()).filter(WorkspaceImage.class::isInstance).map(WorkspaceImage.class::cast);
        return optionalStyle.map(style -> {
            String identifier = this.getIdentifier();
            return SiriusDiagramImageNode.newImageNode(identifier, this.getSemanticElementIdentifier()).label(this.getLabel(identifier, (BasicLabelStyle)style)).imagePath(this.getImagePath((WorkspaceImage)style)).ports(this.getPorts()).build();
        });
    }

    private String getImagePath(WorkspaceImage style) {
        return SiriusDiagramPlugin.getPlugin().getImagePathProvider().flatMap(provider -> provider.getStaticImagePath(style)).orElse(null);
    }
}

