/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.activities;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.server.api.ISiriusServerService;
import org.eclipse.sirius.server.api.SiriusServerPath;
import org.eclipse.sirius.server.api.SiriusServerResponse;
import org.eclipse.sirius.server.backend.internal.services.workflow.SiriusToolServices;
import org.eclipse.sirius.server.backend.internal.services.workflow.WorkflowHelper;
import org.eclipse.sirius.server.backend.internal.utils.SiriusServerUtils;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.workflow.ActivityDescription;

@SiriusServerPath(value="/projects/{projectName}/pages/{pageIdentifier}/sections/{sectionIdentifier}/activities/{activityIdentifier}/execute")
public class SiriusServerActivityExecutorService
implements ISiriusServerService {
    private static final Object PROJECT_NAME = "projectName";
    private static final Object PAGE_IDENTIFIER = "pageIdentifier";
    private static final Object SECTION_IDENTIFIER = "sectionIdentifier";
    private static final Object ACTIVITY_IDENTIFIER = "activityIdentifier";

    public SiriusServerResponse doPost(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        String projectName = variables.get(PROJECT_NAME);
        String pageId = variables.get(PAGE_IDENTIFIER);
        String sectionId = variables.get(SECTION_IDENTIFIER);
        String activityId = variables.get(ACTIVITY_IDENTIFIER);
        Optional<IProject> optionalProject = Optional.ofNullable(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        Optional<ModelingProject> optionalModelingProject = optionalProject.filter(ModelingProject::hasModelingProjectNature).filter(IProject::isOpen).map(iProject -> (ModelingProject)ModelingProject.asModelingProject((IProject)iProject).get());
        if (optionalModelingProject.isPresent()) {
            ModelingProject modelingProject = optionalModelingProject.get();
            Session session = SiriusServerUtils.getSession(modelingProject);
            WorkflowHelper.on(session).findActivityById(pageId, sectionId, activityId).ifPresent(activity -> this.executeActivity(session, (ActivityDescription)activity));
            return new SiriusServerResponse(200);
        }
        return new SiriusServerResponse(404);
    }

    private void executeActivity(final Session session, ActivityDescription activity) {
        final URI taskURI = EcoreUtil.getURI((EObject)activity.getOperation());
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                DAnalysis self = (DAnalysis)((DAnalysisSessionImpl)session).getAnalyses().get(0);
                new SiriusToolServices().executeOperation((EObject)self, taskURI.toString());
            }
        });
    }
}

