/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.common.api;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;

public final class SiriusServicesCommonOptionalUtils {
    private SiriusServicesCommonOptionalUtils() {
    }

    public static Optional<Resource> toResource(Session session, IFile iFile) {
        ResourceSet resourceSet = session.getTransactionalEditingDomain().getResourceSet();
        String path = iFile.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        return Optional.ofNullable(resourceSet.getResource(uri, true));
    }

    public static Optional<ModelingProject> toModelingProject(IProject iProject) {
        return Optional.of(iProject).filter(ModelingProject::hasModelingProjectNature).map(project -> (ModelingProject)ModelingProject.asModelingProject((IProject)project).get());
    }

    public static Optional<Session> toSession(IProject iProject) {
        return Optional.of(iProject).flatMap(SiriusServicesCommonOptionalUtils::toModelingProject).flatMap(SiriusServicesCommonOptionalUtils::toSession);
    }

    public static Optional<Session> toSession(ModelingProject modelingProject) {
        return Optional.of(modelingProject).map(project -> Optional.ofNullable(project.getSession()).orElseGet(() -> {
            URI sessionResourceURI = (URI)project.getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor()).get();
            return SessionManager.INSTANCE.openSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor(), (UICallBack)new NoUICallback());
        }));
    }
}

