/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.api.entities;

import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramEdgeArrowStyle;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramEdgeLineStyle;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramLabel;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramRGBColor;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramColorConverter;

public class SiriusDiagramEdge
extends AbstractSiriusDiagramElement {
    private static final String TYPE = "edge:straight";
    private String sourceId;
    private String targetId;
    private SiriusDiagramLabel label;
    private SiriusDiagramRGBColor color;
    private int size;
    private SiriusDiagramEdgeLineStyle lineStyle;
    private SiriusDiagramEdgeArrowStyle sourceArrowStyle;
    private SiriusDiagramEdgeArrowStyle targetArrowStyle;

    public SiriusDiagramEdge(String identifier, String sourceId, String targetId) {
        super(identifier, TYPE);
        this.sourceId = sourceId;
        this.targetId = targetId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public SiriusDiagramRGBColor getColor() {
        return this.color;
    }

    private void setColor(SiriusDiagramRGBColor color) {
        this.color = color;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        this.size = size;
    }

    public SiriusDiagramEdgeLineStyle getLineStyle() {
        return this.lineStyle;
    }

    private void setLineStyle(SiriusDiagramEdgeLineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public SiriusDiagramEdgeArrowStyle getSourceArrowStyle() {
        return this.sourceArrowStyle;
    }

    private void setSourceArrowStyle(SiriusDiagramEdgeArrowStyle sourceArrowStyle) {
        this.sourceArrowStyle = sourceArrowStyle;
    }

    public SiriusDiagramEdgeArrowStyle getTargetArrowStyle() {
        return this.targetArrowStyle;
    }

    private void setTargetArrowStyle(SiriusDiagramEdgeArrowStyle targetArrowStyle) {
        this.targetArrowStyle = targetArrowStyle;
    }

    public SiriusDiagramLabel getLabel() {
        return this.label;
    }

    private void setLabel(SiriusDiagramLabel label) {
        this.label = label;
    }

    public static Builder newEdge(String identifier, String sourceId, String targetId) {
        return new Builder(identifier, sourceId, targetId);
    }

    public static final class Builder {
        private String identifier;
        private String sourceId;
        private String targetId;
        private SiriusDiagramRGBColor color = SiriusDiagramColorConverter.DEFAULT_COLOR;
        private int size = 1;
        private SiriusDiagramLabel label;
        private SiriusDiagramEdgeLineStyle lineStyle = SiriusDiagramEdgeLineStyle.SOLID;
        private SiriusDiagramEdgeArrowStyle sourceArrowStyle = SiriusDiagramEdgeArrowStyle.NO_DECORATION;
        private SiriusDiagramEdgeArrowStyle targetArrowStyle = SiriusDiagramEdgeArrowStyle.NO_DECORATION;

        private Builder(String identifier, String sourceId, String targetId) {
            this.identifier = identifier;
            this.sourceId = sourceId;
            this.targetId = targetId;
        }

        public Builder color(SiriusDiagramRGBColor color) {
            this.color = color;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder lineStyle(SiriusDiagramEdgeLineStyle lineStyle) {
            this.lineStyle = lineStyle;
            return this;
        }

        public Builder sourceArrowStyle(SiriusDiagramEdgeArrowStyle sourceArrowStyle) {
            this.sourceArrowStyle = sourceArrowStyle;
            return this;
        }

        public Builder targetArrowStyle(SiriusDiagramEdgeArrowStyle targetArrowStyle) {
            this.targetArrowStyle = targetArrowStyle;
            return this;
        }

        public Builder label(SiriusDiagramLabel label) {
            this.label = label;
            return this;
        }

        public SiriusDiagramEdge build() {
            SiriusDiagramEdge edge = new SiriusDiagramEdge(this.identifier, this.sourceId, this.targetId);
            edge.setColor(this.color);
            edge.setSize(this.size);
            edge.setLineStyle(this.lineStyle);
            edge.setSourceArrowStyle(this.sourceArrowStyle);
            edge.setTargetArrowStyle(this.targetArrowStyle);
            edge.setLabel(this.label);
            return edge;
        }
    }
}

