/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.api.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramNode;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramLabel;

public class SiriusDiagramImageNode
extends AbstractSiriusDiagramNode {
    private static final String TYPE = "node:image";
    private String imagePath;
    private SiriusDiagramLabel label;
    private List<AbstractSiriusDiagramElement> ports = new ArrayList<AbstractSiriusDiagramElement>();

    public SiriusDiagramImageNode(String identifier, String semanticElementIdentifier) {
        super(identifier, semanticElementIdentifier, TYPE);
    }

    public String getImagePath() {
        return this.imagePath;
    }

    private void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public SiriusDiagramLabel getLabel() {
        return this.label;
    }

    private void setLabel(SiriusDiagramLabel label) {
        this.label = label;
    }

    public List<AbstractSiriusDiagramElement> getPorts() {
        return this.ports;
    }

    public static Builder newImageNode(String identifier, String semanticElementIdentifier) {
        return new Builder(identifier, semanticElementIdentifier);
    }

    public static final class Builder {
        private String identifier;
        private String semanticElementIdentifier;
        private SiriusDiagramLabel label;
        private String imagePath;
        private List<AbstractSiriusDiagramElement> ports;

        private Builder(String identifier, String semanticElementIdentifier) {
            this.identifier = Objects.requireNonNull(identifier);
            this.semanticElementIdentifier = Objects.requireNonNull(semanticElementIdentifier);
        }

        public Builder label(SiriusDiagramLabel label) {
            this.label = label;
            return this;
        }

        public Builder imagePath(String imagePath) {
            this.imagePath = imagePath;
            return this;
        }

        public Builder ports(List<AbstractSiriusDiagramElement> ports) {
            this.ports = Objects.requireNonNull(ports);
            return this;
        }

        public SiriusDiagramImageNode build() {
            SiriusDiagramImageNode imageNode = new SiriusDiagramImageNode(this.identifier, this.semanticElementIdentifier);
            imageNode.setImagePath(this.imagePath);
            imageNode.setLabel(this.label);
            imageNode.getPorts().addAll(this.ports);
            return imageNode;
        }
    }
}

