/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.converter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramListNode;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramRGBColor;
import org.eclipse.sirius.services.diagram.internal.converter.AbstractSiriusDiagramNodeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.ISiriusDiagramElementConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramColorConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramElementSwitch;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;

public class SiriusDiagramListNodeConverter
extends AbstractSiriusDiagramNodeConverter {
    private DNodeList dNodeList;

    public SiriusDiagramListNodeConverter(DNodeList dNodeList) {
        this.dNodeList = dNodeList;
    }

    @Override
    protected AbstractDNode getDNode() {
        return this.dNodeList;
    }

    @Override
    public Optional<AbstractSiriusDiagramElement> convert() {
        Optional<FlatContainerStyle> optionalStyle = Optional.of(this.dNodeList.getStyle()).filter(FlatContainerStyle.class::isInstance).map(FlatContainerStyle.class::cast);
        return optionalStyle.map(style -> {
            String identifier = this.getIdentifier();
            return SiriusDiagramListNode.newListNode(identifier, this.getSemanticElementIdentifier()).backgroundColor(this.getBackgroundColor((FlatContainerStyle)style)).bordercolor(this.getBorderColor((BorderedStyle)style)).borderSize(this.getBorderSize((BorderedStyle)style)).label(this.getLabel(identifier, (BasicLabelStyle)style)).imagePath(this.getImagePath()).ports(this.getPorts()).withChildren(this.getChildren()).build();
        });
    }

    private SiriusDiagramRGBColor getBackgroundColor(FlatContainerStyle style) {
        return SiriusDiagramColorConverter.convert(style.getBackgroundColor());
    }

    private List<AbstractSiriusDiagramElement> getChildren() {
        return this.dNodeList.getOwnedElements().stream().filter(DDiagramElement::isVisible).map(new SiriusDiagramElementSwitch()::doSwitch).map(ISiriusDiagramElementConverter::convert).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

