/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.matcher;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class WithSemantic
extends BaseMatcher<EditPart> {
    private final EObject semantic;

    public WithSemantic(EObject semantic) {
        this.semantic = semantic;
    }

    public static Matcher<EditPart> withSemantic(EObject semantic) {
        Preconditions.checkNotNull((Object)semantic, (Object)"Can't execute this matcher on a null semantic elt");
        return new WithSemantic(semantic);
    }

    public boolean matches(Object item) {
        View view;
        EObject element;
        EditPart editPart;
        Object model;
        boolean result = false;
        if (item instanceof EditPart && (model = (editPart = (EditPart)item).getModel()) instanceof View && (element = (view = (View)model).getElement()) instanceof DSemanticDecorator) {
            DSemanticDecorator dSemanticDecorator = (DSemanticDecorator)element;
            EObject semanticTarget = dSemanticDecorator.getTarget();
            result = semanticTarget != null && semanticTarget.equals(this.semantic);
        }
        return result;
    }

    public void describeTo(Description description) {
        description.appendText("Matcher to get all EditParts referencing indirectly : " + this.semantic + ", which are child EditParts of contextual EditPart");
    }
}

