/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.ViewpointSelector;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class ActivateViewpointField {
    private static final String ACTIVATE_VIEWPOINT_FIELD = "activateViewpoint";
    private static final String PROJECT_NAME_ARG = "projectName";
    private static final String VIEWPOINT_IDENTIFIER_ARG = "viewpointIdentifier";

    private ActivateViewpointField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(ACTIVATE_VIEWPOINT_FIELD).argument(ActivateViewpointField.getProjectNameArgument()).argument(ActivateViewpointField.getViewpointIdentifierArgument()).type((GraphQLOutputType)new GraphQLTypeReference("Project")).dataFetcher(ActivateViewpointField.getActivateViewpointDataFetcher()).build();
    }

    private static GraphQLArgument getProjectNameArgument() {
        return GraphQLArgument.newArgument().name(PROJECT_NAME_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static GraphQLArgument getViewpointIdentifierArgument() {
        return GraphQLArgument.newArgument().name(VIEWPOINT_IDENTIFIER_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static DataFetcher<IProject> getActivateViewpointDataFetcher() {
        return environment -> {
            Optional<String> optionalProjectName = Optional.of(environment.getArgument(PROJECT_NAME_ARG)).filter(String.class::isInstance).map(String.class::cast);
            Optional<IProject> optionalProject = optionalProjectName.map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getProject(arg_0));
            Optional optionalSession = optionalProject.flatMap(SiriusServicesCommonOptionalUtils::toSession);
            Optional<String> optionalViewpointIdentifier = Optional.of(environment.getArgument(VIEWPOINT_IDENTIFIER_ARG)).filter(String.class::isInstance).map(String.class::cast);
            Optional optionalViewpoint = optionalViewpointIdentifier.flatMap(viewpointIdentifier -> ViewpointRegistry.getInstance().getViewpoints().stream().filter(viewpoint -> viewpointIdentifier.equals(viewpoint.getName())).findFirst());
            optionalSession.ifPresent(session -> optionalViewpoint.ifPresent(viewpoint -> {
                RecordingCommand command = new RecordingCommand(session.getTransactionalEditingDomain(), (Session)session, (Viewpoint)viewpoint){
                    private final /* synthetic */ Session val$session;
                    private final /* synthetic */ Viewpoint val$viewpoint;
                    {
                        this.val$session = session;
                        this.val$viewpoint = viewpoint;
                        super($anonymous0);
                    }

                    protected void doExecute() {
                        new ViewpointSelector(this.val$session).selectViewpoint(SiriusResourceHelper.getCorrespondingViewpoint((Session)this.val$session, (Viewpoint)this.val$viewpoint), false, (IProgressMonitor)new NullProgressMonitor());
                    }
                };
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
            }));
            return optionalProject.orElse(null);
        };
    }
}

