/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.workspace.internal.schema;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.services.graphql.workspace.internal.SiriusGraphQLWorkspacePlugin;

public final class ContainerResourcesField {
    private static final String RESOURCES_FIELD = "resources";
    private static final int COMPLEXITY = 1;

    private ContainerResourcesField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(RESOURCES_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("ContainerResourceConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(ContainerResourcesField.getResourcesDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getResourcesDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> Optional.of(environment.getSource()).filter(IContainer.class::isInstance).map(IContainer.class::cast).map(ContainerResourcesField::getResources).map(iResourceArray -> Arrays.asList(iResourceArray)).orElseGet(ArrayList::new), ContainerResourcesField::computeCursor);
    }

    private static String computeCursor(IResource resource) {
        String unEncodedCursor = resource.getName();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }

    private static IResource[] getResources(IContainer iContainer) {
        try {
            return iContainer.members();
        }
        catch (CoreException exception) {
            Status status = new Status(4, "org.eclipse.sirius.services.graphql.workspace", exception.getMessage(), (Throwable)exception);
            SiriusGraphQLWorkspacePlugin.getPlugin().log(status);
            return new IResource[0];
        }
    }
}

