/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentDependency;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.OrthogonalRoutingGenerator;
import org.eclipse.elk.core.util.Pair;

public final class HyperEdgeSegmentSplitter {
    private OrthogonalRoutingGenerator routingGenerator;

    public HyperEdgeSegmentSplitter(OrthogonalRoutingGenerator routingGenerator) {
        this.routingGenerator = routingGenerator;
    }

    public void splitSegments(List<HyperEdgeSegmentDependency> dependenciesToResolve, List<HyperEdgeSegment> segments, double criticalConflictThreshold) {
        if (dependenciesToResolve.isEmpty()) {
            return;
        }
        List<FreeArea> freeAreas = this.findFreeAreas(segments, criticalConflictThreshold);
        LinkedHashSet<HyperEdgeSegment> segmentsToSplit = this.decideWhichSegmentsToSplit(dependenciesToResolve);
        segmentsToSplit.stream().sorted((hes1, hes2) -> Double.compare(hes1.getLength(), hes2.getLength())).forEach(segment -> this.split((HyperEdgeSegment)segment, segments, freeAreas, criticalConflictThreshold));
    }

    private List<FreeArea> findFreeAreas(List<HyperEdgeSegment> segments, double criticalConflictThreshold) {
        ArrayList<FreeArea> freeAreas = new ArrayList<FreeArea>();
        Stream inCoordinates = segments.stream().flatMap(s -> s.getIncomingConnectionCoordinates().stream());
        Stream outCoordinates = segments.stream().flatMap(s -> s.getOutgoingConnectionCoordinates().stream());
        double[] sortedCoordinates = Streams.concat((Stream[])new Stream[]{inCoordinates, outCoordinates}).mapToDouble(coordinate -> coordinate).sorted().toArray();
        int i = 1;
        while (i < sortedCoordinates.length) {
            if (sortedCoordinates[i] - sortedCoordinates[i - 1] >= 2.0 * criticalConflictThreshold) {
                freeAreas.add(new FreeArea(sortedCoordinates[i - 1] + criticalConflictThreshold, sortedCoordinates[i] - criticalConflictThreshold));
            }
            ++i;
        }
        return freeAreas;
    }

    private LinkedHashSet<HyperEdgeSegment> decideWhichSegmentsToSplit(List<HyperEdgeSegmentDependency> dependencies) {
        LinkedHashSet<HyperEdgeSegment> segmentsToSplit = new LinkedHashSet<HyperEdgeSegment>();
        for (HyperEdgeSegmentDependency dependency : dependencies) {
            HyperEdgeSegment sourceSegment = dependency.getSource();
            HyperEdgeSegment targetSegment = dependency.getTarget();
            if (segmentsToSplit.contains(sourceSegment) || segmentsToSplit.contains(targetSegment)) continue;
            HyperEdgeSegment segmentToSplit = sourceSegment;
            HyperEdgeSegment segmentCausingSplit = targetSegment;
            if (sourceSegment.representsHyperedge() && !targetSegment.representsHyperedge()) {
                segmentToSplit = targetSegment;
                segmentCausingSplit = sourceSegment;
            }
            segmentsToSplit.add(segmentToSplit);
            segmentToSplit.setSplitBy(segmentCausingSplit);
        }
        return segmentsToSplit;
    }

    private void split(HyperEdgeSegment segment, List<HyperEdgeSegment> segments, List<FreeArea> freeAreas, double criticalConflictThreshold) {
        double splitPosition = this.computePositionToSplitAndUpdateFreeAreas(segment, freeAreas, criticalConflictThreshold);
        segments.add(segment.splitAt(splitPosition));
        this.updateDependencies(segment, segments);
    }

    private void updateDependencies(HyperEdgeSegment segment, List<HyperEdgeSegment> segments) {
        HyperEdgeSegment splitCausingSegment = segment.getSplitBy();
        HyperEdgeSegment splitPartner = segment.getSplitPartner();
        HyperEdgeSegmentDependency.createAndAddCritical(segment, splitCausingSegment);
        HyperEdgeSegmentDependency.createAndAddCritical(splitCausingSegment, splitPartner);
        for (HyperEdgeSegment otherSegment : segments) {
            if (otherSegment == splitCausingSegment || otherSegment == segment || otherSegment == splitPartner) continue;
            this.routingGenerator.createDependencyIfNecessary(otherSegment, segment);
            this.routingGenerator.createDependencyIfNecessary(otherSegment, splitPartner);
        }
    }

    private double computePositionToSplitAndUpdateFreeAreas(HyperEdgeSegment segment, List<FreeArea> freeAreas, double criticalConflictThreshold) {
        int firstPossibleAreaIndex = -1;
        int lastPossibleAreaIndex = -1;
        int i = 0;
        while (i < freeAreas.size()) {
            FreeArea currArea = freeAreas.get(i);
            if (currArea.startPosition > segment.getEndCoordinate()) break;
            if (currArea.endPosition >= segment.getStartCoordinate()) {
                if (firstPossibleAreaIndex < 0) {
                    firstPossibleAreaIndex = i;
                }
                lastPossibleAreaIndex = i;
            }
            ++i;
        }
        double splitPosition = HyperEdgeSegmentSplitter.center(segment);
        if (firstPossibleAreaIndex >= 0) {
            int bestAreaIndex = this.chooseBestAreaIndex(segment, freeAreas, firstPossibleAreaIndex, lastPossibleAreaIndex);
            splitPosition = HyperEdgeSegmentSplitter.center(freeAreas.get(bestAreaIndex));
            this.useArea(freeAreas, bestAreaIndex, criticalConflictThreshold);
        }
        return splitPosition;
    }

    private int chooseBestAreaIndex(HyperEdgeSegment segment, List<FreeArea> freeAreas, int fromIndex, int toIndex) {
        int bestAreaIndex = fromIndex;
        if (fromIndex < toIndex) {
            Pair<HyperEdgeSegment, HyperEdgeSegment> splitSegments = segment.simulateSplit();
            HyperEdgeSegment splitSegment = (HyperEdgeSegment)splitSegments.getFirst();
            HyperEdgeSegment splitPartner = (HyperEdgeSegment)splitSegments.getSecond();
            FreeArea bestArea = freeAreas.get(bestAreaIndex);
            AreaRating bestRating = this.rateArea(segment, splitSegment, splitPartner, bestArea);
            int i = fromIndex + 1;
            while (i <= toIndex) {
                AreaRating currRating;
                FreeArea currArea = freeAreas.get(i);
                if (this.isBetter(currArea, currRating = this.rateArea(segment, splitSegment, splitPartner, currArea), bestArea, bestRating)) {
                    bestArea = currArea;
                    bestRating = currRating;
                }
                ++i;
            }
        }
        return bestAreaIndex;
    }

    private AreaRating rateArea(HyperEdgeSegment segment, HyperEdgeSegment splitSegment, HyperEdgeSegment splitPartner, FreeArea area) {
        HyperEdgeSegment otherSegment;
        double areaCentre = HyperEdgeSegmentSplitter.center(area);
        splitSegment.getOutgoingConnectionCoordinates().clear();
        splitSegment.getOutgoingConnectionCoordinates().add(areaCentre);
        splitPartner.getIncomingConnectionCoordinates().clear();
        splitPartner.getIncomingConnectionCoordinates().add(areaCentre);
        AreaRating rating = new AreaRating(0, 0);
        for (HyperEdgeSegmentDependency dependency : segment.getIncomingSegmentDependencies()) {
            otherSegment = dependency.getSource();
            this.updateConsideringBothOrderings(rating, splitSegment, otherSegment);
            this.updateConsideringBothOrderings(rating, splitPartner, otherSegment);
        }
        for (HyperEdgeSegmentDependency dependency : segment.getOutgoingSegmentDependencies()) {
            otherSegment = dependency.getTarget();
            this.updateConsideringBothOrderings(rating, splitSegment, otherSegment);
            this.updateConsideringBothOrderings(rating, splitPartner, otherSegment);
        }
        AreaRating areaRating = rating;
        areaRating.dependencies = areaRating.dependencies + 2;
        AreaRating areaRating2 = rating;
        areaRating2.crossings = areaRating2.crossings + this.countCrossingsForSingleOrdering(splitSegment, segment.getSplitBy());
        AreaRating areaRating3 = rating;
        areaRating3.crossings = areaRating3.crossings + this.countCrossingsForSingleOrdering(segment.getSplitBy(), splitPartner);
        return rating;
    }

    private void updateConsideringBothOrderings(AreaRating rating, HyperEdgeSegment s1, HyperEdgeSegment s2) {
        int crossingsS2LeftOfS1;
        int crossingsS1LeftOfS2 = this.countCrossingsForSingleOrdering(s1, s2);
        if (crossingsS1LeftOfS2 == (crossingsS2LeftOfS1 = this.countCrossingsForSingleOrdering(s2, s1))) {
            if (crossingsS1LeftOfS2 > 0) {
                AreaRating areaRating = rating;
                areaRating.dependencies = areaRating.dependencies + 2;
                AreaRating areaRating2 = rating;
                areaRating2.crossings = areaRating2.crossings + crossingsS1LeftOfS2;
            }
        } else {
            AreaRating areaRating = rating;
            areaRating.dependencies = areaRating.dependencies + 1;
            AreaRating areaRating3 = rating;
            areaRating3.crossings = areaRating3.crossings + Math.min(crossingsS1LeftOfS2, crossingsS2LeftOfS1);
        }
    }

    private int countCrossingsForSingleOrdering(HyperEdgeSegment left, HyperEdgeSegment right) {
        return OrthogonalRoutingGenerator.countCrossings(left.getOutgoingConnectionCoordinates(), right.getStartCoordinate(), right.getEndCoordinate()) + OrthogonalRoutingGenerator.countCrossings(right.getIncomingConnectionCoordinates(), left.getStartCoordinate(), left.getEndCoordinate());
    }

    private boolean isBetter(FreeArea currArea, AreaRating currRating, FreeArea bestArea, AreaRating bestRating) {
        if (currRating.crossings < bestRating.crossings) {
            return true;
        }
        if (currRating.crossings == bestRating.crossings) {
            if (currRating.dependencies < bestRating.dependencies) {
                return true;
            }
            if (currRating.dependencies == bestRating.dependencies && currArea.size > bestArea.size) {
                return true;
            }
        }
        return false;
    }

    private void useArea(List<FreeArea> freeAreas, int usedAreaIndex, double criticalConflictThreshold) {
        FreeArea oldArea = freeAreas.get(usedAreaIndex);
        freeAreas.remove(usedAreaIndex);
        if (oldArea.size / 2.0 >= criticalConflictThreshold) {
            double newStart2;
            int insertIndex = usedAreaIndex;
            double oldAreaCentre = HyperEdgeSegmentSplitter.center(oldArea);
            double newEnd1 = oldAreaCentre - criticalConflictThreshold;
            if (oldArea.startPosition <= oldAreaCentre - criticalConflictThreshold) {
                FreeArea newArea1 = new FreeArea(oldArea.startPosition, newEnd1);
                freeAreas.add(insertIndex++, newArea1);
            }
            if ((newStart2 = oldAreaCentre + criticalConflictThreshold) <= oldArea.endPosition) {
                FreeArea newArea2 = new FreeArea(newStart2, oldArea.endPosition);
                freeAreas.add(insertIndex, newArea2);
            }
        }
    }

    private static double center(HyperEdgeSegment s) {
        return HyperEdgeSegmentSplitter.center(s.getStartCoordinate(), s.getEndCoordinate());
    }

    private static double center(FreeArea a) {
        return HyperEdgeSegmentSplitter.center(a.startPosition, a.endPosition);
    }

    private static double center(double p1, double p2) {
        return (p1 + p2) / 2.0;
    }

    private static final class AreaRating {
        private int dependencies;
        private int crossings;

        private AreaRating(int dependencies, int crossings) {
            this.dependencies = dependencies;
            this.crossings = crossings;
        }
    }

    private static final class FreeArea {
        private final double startPosition;
        private final double endPosition;
        private final double size;

        private FreeArea(double startPosition, double endPosition) {
            assert (endPosition >= startPosition);
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.size = endPosition - startPosition;
        }
    }
}

