/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class ActivatedViewpointsField {
    private static final String ACTIVATED_VIEWPOINTS = "activatedViewpoints";
    private static final int ACTIVATED_VIEWPOINTS_COMPLEXITY = 1;

    private ActivatedViewpointsField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(ACTIVATED_VIEWPOINTS).type((GraphQLOutputType)new GraphQLTypeReference("ProjectViewpointConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(ActivatedViewpointsField.getActivatedViewpointsDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getActivatedViewpointsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Optional<IProject> optionalProject = Optional.of(environment.getSource()).filter(IProject.class::isInstance).map(IProject.class::cast);
            return optionalProject.flatMap(SiriusServicesCommonOptionalUtils::toSession).map(session -> {
                ArrayList viewpoints = new ArrayList(session.getSelectedViewpoints(true));
                return viewpoints;
            }).orElseGet(ArrayList::new);
        }, ActivatedViewpointsField::computeViewpointCursor);
    }

    private static String computeViewpointCursor(Viewpoint viewpoint) {
        String unEncodedCursor = EcoreUtil.getURI((EObject)viewpoint).toString();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

