/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.helper.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.CompositeFilterDescriptionQuery;
import org.eclipse.sirius.diagram.business.internal.helper.filter.VariableFilterWrapper;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterKind;
import org.eclipse.sirius.diagram.description.filter.FilterPackage;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public final class FilterService {
    private FilterService() {
    }

    public static List<FilterDescription> getAppliedFilters(DDiagram diagram, DDiagramElement element) {
        EList<FilterDescription> filters = diagram.getActivatedFilters();
        if (filters.isEmpty()) {
            return Collections.emptyList();
        }
        return FilterService.getAppliedFiltersOnElement(filters, element);
    }

    private static List<FilterDescription> getAppliedFiltersOnElement(List<FilterDescription> filters, DDiagramElement element) {
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>();
        for (FilterDescription filter : filters) {
            if (FilterService.isVisible(filter, element)) continue;
            result.add(filter);
        }
        return result;
    }

    private static boolean isVisible(FilterDescription filterDescription, DDiagramElement element) {
        if (filterDescription instanceof CompositeFilterDescription) {
            CompositeFilterDescription compositeFilterDescription = (CompositeFilterDescription)filterDescription;
            for (Filter filter : compositeFilterDescription.getFilters()) {
                if (FilterService.isVisible(filter, element) || filter.getFilterKind() != FilterKind.HIDE_LITERAL) continue;
                return false;
            }
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private static boolean checkExpression(Filter filter, EObject element, EStructuralFeature eFeature) {
        IInterpreter acceleoInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element);
        boolean valid = true;
        String expression = (String)filter.eGet(eFeature);
        if (expression != null) {
            try {
                valid = acceleoInterpreter.evaluateBoolean(element, expression);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)filter, eFeature, (Throwable)e);
            }
        }
        return valid;
    }

    private static boolean isVisible(VariableFilter filter, DDiagramElement element) {
        Optional<VariableFilterWrapper> variableFilterWrapper = element.eAdapters().stream().filter(VariableFilterWrapper.class::isInstance).map(VariableFilterWrapper.class::cast).findFirst();
        if (variableFilterWrapper.isPresent()) {
            return variableFilterWrapper.get().isVisible(element);
        }
        VariableFilterWrapper newVariableFilterWrapper = new VariableFilterWrapper(filter);
        filter.eAdapters().add((Object)newVariableFilterWrapper);
        return newVariableFilterWrapper.isVisible(element);
    }

    private static boolean isVisible(MappingFilter filter, DDiagramElement element) {
        Boolean visible = null;
        if (filter.getMappings().size() == 0) {
            if (filter.getSemanticConditionExpression() != null && !filter.getSemanticConditionExpression().trim().isEmpty() && !FilterService.checkExpression(filter, (EObject)element, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_SemanticConditionExpression())) {
                visible = Boolean.FALSE;
            }
            if (filter.getViewConditionExpression() != null && !filter.getViewConditionExpression().trim().isEmpty() && !FilterService.checkExpression(filter, (EObject)element, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_ViewConditionExpression())) {
                visible = Boolean.FALSE;
            }
        } else {
            RepresentationElementMapping mapping = element.getMapping();
            if (mapping != null && FilterService.doManage(filter, (EObject)mapping)) {
                EObject semantic;
                boolean hasViewExpression;
                boolean hasSemanticExpression = filter.getSemanticConditionExpression() != null && !filter.getSemanticConditionExpression().trim().isEmpty();
                boolean bl = hasViewExpression = filter.getViewConditionExpression() != null && !filter.getViewConditionExpression().trim().isEmpty();
                if (!hasSemanticExpression && !hasViewExpression) {
                    visible = Boolean.FALSE;
                }
                if (hasSemanticExpression && (semantic = element.getTarget()) != null && !FilterService.checkExpression(filter, semantic, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_SemanticConditionExpression())) {
                    visible = Boolean.FALSE;
                }
                if (hasViewExpression && !FilterService.checkExpression(filter, (EObject)element, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_ViewConditionExpression())) {
                    visible = Boolean.FALSE;
                }
            }
        }
        if (visible == null) {
            visible = Boolean.TRUE;
        }
        return visible;
    }

    public static boolean isVisible(Filter filter, DDiagramElement element) {
        if (filter instanceof VariableFilter) {
            return FilterService.isVisible((VariableFilter)filter, element);
        }
        if (filter instanceof MappingFilter) {
            return FilterService.isVisible((MappingFilter)filter, element);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean doManage(MappingFilter filter, EObject mapping) {
        boolean result = false;
        if (filter.getMappings().contains((Object)mapping)) {
            result = true;
        } else {
            EObject importedMapping = FilterService.getImportedMapping(mapping);
            if (importedMapping != null) {
                result = FilterService.doManage(filter, importedMapping) && FilterService.isInheritsAncestorFilters(mapping);
            }
        }
        return result;
    }

    private static EObject getImportedMapping(EObject mapping) {
        Object result = null;
        if (mapping instanceof NodeMappingImport) {
            result = ((NodeMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof ContainerMappingImport) {
            result = ((ContainerMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof EdgeMappingImport) {
            result = ((EdgeMappingImport)mapping).getImportedMapping();
        }
        return result;
    }

    private static boolean isInheritsAncestorFilters(EObject mapping) {
        boolean result = false;
        if (mapping instanceof AbstractMappingImport) {
            result = ((AbstractMappingImport)mapping).isInheritsAncestorFilters();
        } else if (mapping instanceof EdgeMappingImport) {
            result = ((EdgeMappingImport)mapping).isInheritsAncestorFilters();
        }
        return result;
    }

    public static boolean isCollapsed(DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.IS_COLLAPSED_KEY);
        boolean isCollapsed = false;
        if (DisplayServiceManager.INSTANCE.getMode() != DisplayMode.ALL_IS_DISPLAYED) {
            isCollapsed = FilterService.isCollapsed(diagram.getActivatedFilters(), element);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.IS_COLLAPSED_KEY);
        return isCollapsed;
    }

    private static boolean isCollapsed(Collection<FilterDescription> sortedFilters, DDiagramElement element) {
        boolean isCollapsed = false;
        Iterator<FilterDescription> it = sortedFilters.iterator();
        block0: while (it.hasNext() && !isCollapsed) {
            FilterDescription filter = it.next();
            if (!(filter instanceof CompositeFilterDescription)) continue;
            CompositeFilterDescriptionQuery query = new CompositeFilterDescriptionQuery((CompositeFilterDescription)filter);
            for (Filter currentFilter : query.getCollapseFilters()) {
                isCollapsed = FilterService.isFilterCollapsed(currentFilter, element);
                if (isCollapsed) continue block0;
            }
        }
        return isCollapsed;
    }

    private static boolean isFilterCollapsed(Filter filter, DDiagramElement element) {
        return filter.getFilterKind() == FilterKind.COLLAPSE_LITERAL && !FilterService.isVisible(filter, element);
    }

    public static List<FilterDescription> sortFilters(Collection<FilterDescription> filters) {
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>(filters);
        Collections.sort(result, new Comparator<FilterDescription>(){

            private boolean ownsACollapsedFilter(FilterDescription filterDescription) {
                if (filterDescription instanceof CompositeFilterDescription) {
                    CompositeFilterDescriptionQuery query = new CompositeFilterDescriptionQuery((CompositeFilterDescription)filterDescription);
                    return !query.getCollapseFilters().isEmpty();
                }
                return false;
            }

            @Override
            public int compare(FilterDescription o1, FilterDescription o2) {
                FilterDescription filterDescription0 = o1;
                FilterDescription filterDescription1 = o2;
                boolean hasCollapse0 = this.ownsACollapsedFilter(filterDescription0);
                boolean hasCollapse1 = this.ownsACollapsedFilter(filterDescription1);
                int result = 0;
                result = hasCollapse0 && !hasCollapse1 ? 1 : (hasCollapse1 && !hasCollapse0 ? -1 : this.getHashCode(filterDescription0) - this.getHashCode(filterDescription1));
                return result;
            }

            private int getHashCode(FilterDescription filterDescription) {
                int result = filterDescription.hashCode();
                if (filterDescription.eContainer() instanceof IdentifiedElement && !StringUtil.isEmpty((String)((IdentifiedElement)filterDescription.eContainer()).getName()) && !StringUtil.isEmpty((String)filterDescription.getName())) {
                    result = ((IdentifiedElement)filterDescription.eContainer()).getName().hashCode() + filterDescription.getName().hashCode();
                }
                return result;
            }
        });
        return result;
    }
}

