/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DRepresentationChangeListener
extends ResourceSetListenerImpl {
    private DAnalysisSession session;

    public DRepresentationChangeListener(DAnalysisSession session) {
        this.session = session;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        List notifications = event.getNotifications();
        boolean subDiagramDecorationDesciptorCleared = false;
        Collection<DRepresentation> allLoadedRepresentations = DialectManager.INSTANCE.getAllLoadedRepresentations(this.session);
        LinkedHashSet<DRepresentationDescriptor> dRepresentationDescriptorsSetToValidate = new LinkedHashSet<DRepresentationDescriptor>();
        for (Notification notification : notifications) {
            if (notification.getNewValue() instanceof DRepresentation || notification.getOldValue() instanceof DRepresentation) {
                allLoadedRepresentations.stream().forEach(rep -> rep.getUiState().getSubDiagramDecorationDescriptors().clear());
                subDiagramDecorationDesciptorCleared = true;
                break;
            }
            if (notification.getNotifier() instanceof DView && ViewpointPackage.eINSTANCE.getDView_OwnedRepresentationDescriptors().equals(notification.getFeature())) {
                switch (notification.getEventType()) {
                    case 4: {
                        dRepresentationDescriptorsSetToValidate.add((DRepresentationDescriptor)notification.getOldValue());
                        break;
                    }
                    case 6: {
                        dRepresentationDescriptorsSetToValidate.addAll((Collection)notification.getOldValue());
                        break;
                    }
                    case 3: {
                        dRepresentationDescriptorsSetToValidate.add((DRepresentationDescriptor)notification.getNewValue());
                        break;
                    }
                    case 5: {
                        dRepresentationDescriptorsSetToValidate.addAll((Collection)notification.getNewValue());
                        break;
                    }
                }
                continue;
            }
            if (!(notification.getNotifier() instanceof DRepresentationDescriptor)) continue;
            dRepresentationDescriptorsSetToValidate.add((DRepresentationDescriptor)notification.getNotifier());
        }
        if (!subDiagramDecorationDesciptorCleared) {
            allLoadedRepresentations.stream().forEach(rep -> {
                Iterator<Map.Entry<Object, Object>> it = rep.getUiState().getSubDiagramDecorationDescriptors().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> next = it.next();
                    if (!(next.getValue() instanceof NoSubDecorationDescriptor)) continue;
                    it.remove();
                }
            });
        }
        for (DRepresentationDescriptor dRepresentationDescriptorToValidate : dRepresentationDescriptorsSetToValidate) {
            Optional<DRepresentationDescriptorQuery.DRepresentationDescriptorValidityAdapter> findFirst = dRepresentationDescriptorToValidate.eAdapters().stream().filter(DRepresentationDescriptorQuery.DRepresentationDescriptorValidityAdapter.class::isInstance).map(DRepresentationDescriptorQuery.DRepresentationDescriptorValidityAdapter.class::cast).findFirst();
            if (!findFirst.isPresent()) continue;
            findFirst.get().triggerRepresentationValidation();
        }
    }

    public NotificationFilter getFilter() {
        NotificationFilter filter = super.getFilter();
        filter = filter.and((NotificationFilter)new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                Object notifier = notification.getNotifier();
                return !notification.isTouch() && notifier instanceof EObject && !new NotificationQuery(notification).isTransientNotification();
            }
        });
        return filter;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public static final class NoSubDecorationDescriptor {
    }
}

