/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ColorPalettePopup {
    private static final Integer MAXIMUM_BUTTON_NUMBER = 50;
    private static final Integer BUTTON_COLUMN_NUMBER = 10;
    private static Map<RGB, Image> rgbToImages = new HashMap<RGB, Image>();
    private int previousColor;
    private Button customColorButton;
    private Map<RGB, Button> buttonMap = new LinkedHashMap<RGB, Button>();
    private boolean shouldBeDisposedOnDeactivation = true;
    private static final String CUSTOM_COLOR_STRING = DiagramUIPropertiesMessages.ColorPalettePopup_custom;
    public static final Point ICON_SIZE = new Point(20, 20);
    private Shell shell;
    private RGB selectedColor;
    private boolean useDefaultColor;

    public ColorPalettePopup(Shell parent, int rowHeight, Map<String, RGB> defaultColors) {
        this.shell = new Shell(parent, ColorPalettePopup.checkStyle(0));
        GridLayout layout = new GridLayout(BUTTON_COLUMN_NUMBER.intValue(), true);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        int count = 0;
        for (String colorName : defaultColors.keySet()) {
            ++count;
            Button button = new Button((Composite)this.shell, 8);
            GridData data = new GridData(256);
            data.heightHint = rowHeight;
            data.widthHint = rowHeight;
            button.setLayoutData((Object)data);
            final RGB rgb = defaultColors.get(colorName);
            if (!rgbToImages.containsKey(rgb)) {
                InventoryColorDescriptor colorDesc = new InventoryColorDescriptor(rgb);
                rgbToImages.put(rgb, colorDesc.createImage());
            }
            Image image = rgbToImages.get(rgb);
            button.setImage(image);
            button.setToolTipText(colorName);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e1) {
                    ColorPalettePopup.this.selectedColor = rgb;
                    ColorPalettePopup.this.dispose();
                }
            });
            this.buttonMap.put(rgb, button);
            if (count == MAXIMUM_BUTTON_NUMBER) break;
        }
        Button moreColors = new Button((Composite)this.shell, 8);
        moreColors.setText(CUSTOM_COLOR_STRING);
        GridData data = new GridData(256);
        data.horizontalSpan = 4;
        data.heightHint = rowHeight;
        moreColors.setLayoutData((Object)data);
        moreColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorPalettePopup.this.shouldBeDisposedOnDeactivation = false;
                ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
                dialog.setRGB(FigureUtilities.integerToRGB((Integer)ColorPalettePopup.this.getPreviousColor()));
                WindowUtil.centerDialog((Shell)dialog.getParent(), (Shell)Display.getCurrent().getActiveShell());
                RGB returnedSelectedColor = dialog.open();
                if (returnedSelectedColor != null) {
                    ColorPalettePopup.this.selectedColor = dialog.getRGB();
                }
                ColorPalettePopup.this.dispose();
            }
        });
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                if (ColorPalettePopup.this.shouldBeDisposedOnDeactivation) {
                    ColorPalettePopup.this.dispose();
                } else {
                    ColorPalettePopup.this.shell.setVisible(false);
                }
            }
        });
        this.customColorButton = moreColors;
    }

    private static int checkStyle(int style) {
        int mask = 0x6000000;
        return style & mask;
    }

    public RGB open(Point location) {
        Point listSize = this.shell.computeSize(-1, -1, false);
        this.shell.setBounds(location.x, location.y, listSize.x, listSize.y);
        this.shell.open();
        this.shell.setFocus();
        Display display = this.shell.getDisplay();
        Button prevButton = this.buttonMap.get(FigureUtilities.integerToRGB((Integer)this.getPreviousColor()));
        if (prevButton != null) {
            this.shell.setDefaultButton(prevButton);
            prevButton.setFocus();
        } else {
            this.shell.setDefaultButton(this.customColorButton);
        }
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getSelectedColor();
    }

    public RGB getSelectedColor() {
        return this.selectedColor;
    }

    public boolean useDefaultColor() {
        return this.useDefaultColor;
    }

    public int getPreviousColor() {
        return this.previousColor;
    }

    public void setPreviousColor(int previousColor) {
        this.previousColor = previousColor;
    }

    public void dispose() {
        this.buttonMap.values().forEach(b -> b.dispose());
        this.buttonMap.clear();
        this.shell.dispose();
    }

    private static class InventoryColorDescriptor
    extends ImageDescriptor {
        private static final RGB OUTLINE_COLOR = new RGB(192, 192, 192);
        private RGB rgb;

        InventoryColorDescriptor(RGB colorValue) {
            this.rgb = colorValue;
        }

        public ImageData getImageData() {
            ImageData data = new ImageData(ColorPalettePopup.ICON_SIZE.x, ColorPalettePopup.ICON_SIZE.y, 1, new PaletteData(new RGB[]{this.rgb, OUTLINE_COLOR}));
            int i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.y) {
                data.setPixel(0, i, 1);
                ++i;
            }
            i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.y) {
                data.setPixel(ColorPalettePopup.ICON_SIZE.x - 1, i, 1);
                ++i;
            }
            i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.x) {
                data.setPixel(i, 0, 1);
                ++i;
            }
            i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.x) {
                data.setPixel(i, ColorPalettePopup.ICON_SIZE.y - 1, 1);
                ++i;
            }
            return data;
        }

        public Image createImage() {
            Display device = Display.getCurrent();
            ImageData data = this.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
            }
            try {
                if (data.transparentPixel >= 0) {
                    ImageData maskData = data.getTransparencyMask();
                    return new Image((Device)device, data, maskData);
                }
                return new Image((Device)device, data);
            }
            catch (SWTException sWTException) {
                try {
                    return new Image((Device)device, DEFAULT_IMAGE_DATA);
                }
                catch (SWTException sWTException2) {
                    return null;
                }
            }
        }
    }
}

