/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.compaction;

import java.util.List;
import org.eclipse.elk.graph.ElkNode;

public class AbstractRadiusExtensionCompaction {
    private int compactionStep = 1;
    private double spacing;
    private ElkNode root;

    public void contractLayer(List<ElkNode> layerNodes, boolean isContracting) {
        for (ElkNode node : layerNodes) {
            double xPos = node.getX() + node.getWidth() / 2.0;
            double yPos = node.getY() + node.getHeight() / 2.0;
            ElkNode treeParent = this.root;
            double parentX = treeParent.getX() + treeParent.getWidth() / 2.0;
            double parentY = treeParent.getY() + treeParent.getHeight() / 2.0;
            double x = xPos - parentX;
            double y = yPos - parentY;
            double length = Math.sqrt(x * x + y * y);
            x *= (double)this.compactionStep / length;
            y *= (double)this.compactionStep / length;
            if (isContracting) {
                xPos -= x;
                yPos -= y;
            } else {
                xPos += x;
                yPos += y;
            }
            node.setX(xPos - node.getWidth() / 2.0);
            node.setY(yPos - node.getHeight() / 2.0);
        }
    }

    public boolean overlap(ElkNode node1, ElkNode node2) {
        double x1 = node1.getX() - this.spacing / 2.0;
        double x2 = node2.getX() - this.spacing / 2.0;
        double y1 = node1.getY() - this.spacing / 2.0;
        double y2 = node2.getY() - this.spacing / 2.0;
        double width1 = node1.getWidth() + this.spacing / 2.0;
        double width2 = node2.getWidth() + this.spacing / 2.0;
        double height1 = node1.getHeight() + this.spacing / 2.0;
        double height2 = node2.getHeight() + this.spacing / 2.0;
        if (x1 < x2 + width2 && x2 < x1 && y1 < y2 + height2 && y2 < y1) {
            return true;
        }
        if (x2 < x1 + width1 && x1 < x2 && y2 < y1 + height1 && y1 < y2) {
            return true;
        }
        if (x1 < x2 + width2 && x2 < x1 && y1 < y2 && y2 < y1 + height1) {
            return true;
        }
        return x2 < x1 + width1 && x1 < x2 && y1 < y2 + height2 && y2 < y1;
    }

    public boolean overlapLayer(List<ElkNode> nodes) {
        boolean overlapping = false;
        if (nodes.size() < 2) {
            return false;
        }
        int i = 0;
        while (i < nodes.size()) {
            overlapping = i < nodes.size() - 1 ? (overlapping |= this.overlap(nodes.get(i), nodes.get(i + 1))) : (overlapping |= this.overlap(nodes.get(i), nodes.get(0)));
            ++i;
        }
        return overlapping;
    }

    public int getCompactionStep() {
        return this.compactionStep;
    }

    public void setCompactionStep(int compactionStep) {
        this.compactionStep = compactionStep;
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double spacing) {
        this.spacing = spacing;
    }

    public void setRoot(ElkNode root) {
        this.root = root;
    }

    public ElkNode getRoot() {
        return this.root;
    }
}

