/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.find;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.common.tools.api.find.AbstractFindLabelEngine;
import org.eclipse.sirius.common.tools.api.find.FindMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFindLabelDialog
extends Dialog {
    private Text findText;
    private AbstractFindLabelEngine engine;

    public AbstractFindLabelDialog(Shell parentShell, AbstractFindLabelEngine engine) {
        super(parentShell);
        this.setShellStyle(67696);
        this.engine = engine;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.getShell().setText(FindMessages.abstractFindLabelDialogDialogTitle);
        this.createFindInterface(container);
        return container;
    }

    protected void createFindInterface(Composite container) {
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 2;
        container.setLayout((Layout)containerLayout);
        this.createInputArea(container);
        this.createButtonsArea(container);
    }

    private void createInputArea(Composite container) {
        Composite findArea = new Composite(container, 0);
        GridData findAreaLayoutData = new GridData(768);
        findAreaLayoutData.verticalAlignment = 1;
        findArea.setLayoutData((Object)findAreaLayoutData);
        GridLayout findAreaLayout = new GridLayout();
        findAreaLayout.numColumns = 2;
        findArea.setLayout((Layout)findAreaLayout);
        Label findLabel = new Label(findArea, 0);
        findLabel.setText(FindMessages.abstractFindLabelDialogFindLabel);
        this.findText = new Text(findArea, 2048);
        GridData findTextData = new GridData(768);
        this.findText.setLayoutData((Object)findTextData);
        this.findText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractFindLabelDialog.this.nextClicked(AbstractFindLabelDialog.this.findText.getText());
            }
        });
        this.createDirectionGroup(findArea);
    }

    private void createDirectionGroup(Composite findArea) {
        new Label(findArea, 0).setText(FindMessages.abstractFindLabelDialogDirectionGroup);
        Composite directionSection = new Composite(findArea, 0);
        GridData directionSectionData = new GridData(768);
        directionSectionData.horizontalAlignment = 1;
        directionSectionData.horizontalSpan = 1;
        directionSection.setLayoutData((Object)directionSectionData);
        GridLayout directionGroupLayout = new GridLayout();
        directionGroupLayout.numColumns = 2;
        directionSection.setLayout((Layout)directionGroupLayout);
        this.createButton(directionSection, 16, FindMessages.abstractFindLabelDialogBackwardRadio, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFindLabelDialog.this.engine.setDirection(0);
            }
        });
        Button forward = this.createButton(directionSection, 16, FindMessages.abstractFindLabelDialogForwardRadio, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFindLabelDialog.this.engine.setDirection(1);
            }
        });
        forward.setSelection(true);
    }

    private void createButtonsArea(Composite container) {
        Composite findPanel = new Composite(container, 0);
        GridData findPanelLayoutData = new GridData(768);
        findPanelLayoutData.verticalAlignment = 1;
        findPanel.setLayoutData((Object)findPanelLayoutData);
        GridLayout findPanelLayout = new GridLayout();
        findPanelLayout.numColumns = 1;
        findPanel.setLayout((Layout)findPanelLayout);
        this.createButton(findPanel, 8, FindMessages.abstractFindLabelDialogNextButton, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFindLabelDialog.this.nextClicked(AbstractFindLabelDialog.this.findText.getText());
            }
        });
        this.createButton(findPanel, 8, FindMessages.abstractFindLabelDialogCancelButton, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFindLabelDialog.this.close();
            }
        });
    }

    private Button createButton(Composite parent, int style, String text, SelectionListener listener) {
        Button b = new Button(parent, style);
        b.setText(text);
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener(listener);
        return b;
    }

    protected abstract void selectElement(Object var1);

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void nextClicked(String search) {
        if (search != null && !"".equals(search)) {
            this.engine.initFind(search);
            Object selection = this.engine.getNext();
            if (selection != null) {
                this.selectElement(selection);
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)FindMessages.abstractFindLabelDialogErrorDialogTitle, (String)FindMessages.abstractFindLabelDialogNoMatchingElementMessage);
            }
        }
    }

    protected Point getInitialSize() {
        return new Point(450, 120);
    }
}

