/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtensionFeatureDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExtendedFeatureEditorDialog
extends Dialog {
    protected EList<EObject> result;
    private List<EObject> choices;
    private List<EObject> referenceValues;
    private ExtensionFeatureDescription extReference;
    private boolean multiLine;
    private ItemProvider values;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;

    public ExtendedFeatureEditorDialog(Shell parent, List<EObject> choices, List<EObject> referenceValues, ExtensionFeatureDescription extReference) {
        super(parent);
        this.choices = choices;
        this.referenceValues = referenceValues;
        this.extReference = extReference;
        List adapterFactories = Collections.emptyList();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(adapterFactories);
        this.values = new ItemProvider((AdapterFactory)adapterFactory, this.referenceValues);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        this.choices.removeAll(this.referenceValues);
        this.labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EObject) {
                    ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)element);
                    return accessor.getQualifiedName((EObject)element, true);
                }
                return String.valueOf(element);
            }

            public Image getImage(Object element) {
                ImageDescriptor descriptor = null;
                if (element instanceof EObject) {
                    EObject target = (EObject)element;
                    IItemLabelProvider myLabelProvider = (IItemLabelProvider)DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory().adapt((Notifier)target, IItemLabelProvider.class);
                    descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(myLabelProvider.getImage((Object)target));
                }
                if (descriptor == null) {
                    descriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                return DiagramUIPlugin.getPlugin().getImage(descriptor);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        TableViewer choiceTableViewer;
        Table choiceTable;
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Composite choiceComposite = this.createChoiceComposite(contents);
        Table table = choiceTable = this.choices == null ? null : new Table(choiceComposite, 2050);
        if (choiceTable != null) {
            GridData choiceTableGridData = new GridData();
            choiceTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
            choiceTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
            choiceTableGridData.verticalAlignment = 4;
            choiceTableGridData.horizontalAlignment = 4;
            choiceTableGridData.grabExcessHorizontalSpace = true;
            choiceTableGridData.grabExcessVerticalSpace = true;
            choiceTable.setLayoutData((Object)choiceTableGridData);
        }
        TableViewer tableViewer = choiceTableViewer = this.choices == null ? null : new TableViewer((Composite)choiceTable, 0x10000000);
        if (choiceTableViewer != null) {
            choiceTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new AdapterFactoryImpl()));
            choiceTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            choiceTableViewer.setInput((Object)new ItemProvider(this.choices));
        }
        int style = this.multiLine ? 770 : 2;
        Text choiceText = this.createChoiceText(choiceComposite, style |= 0x800);
        Composite controlButtons = this.createControlButtonsArea(contents);
        new Label(controlButtons, 0);
        Button addButton = this.createAddButton(controlButtons);
        Button removeButton = this.createRemoveButton(controlButtons);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        Button upButton = this.createUpButton(controlButtons);
        Button downButton = this.createDownButton(controlButtons);
        Composite featureComposite = this.createFeatureComposite(contents);
        Table featureTable = new Table(featureComposite, 2050);
        GridData featureTableGridData = new GridData();
        featureTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        featureTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        featureTableGridData.verticalAlignment = 4;
        featureTableGridData.horizontalAlignment = 4;
        featureTableGridData.grabExcessHorizontalSpace = true;
        featureTableGridData.grabExcessVerticalSpace = true;
        featureTable.setLayoutData((Object)featureTableGridData);
        TableViewer featureTableViewer = new TableViewer(featureTable);
        featureTableViewer.setContentProvider(this.contentProvider);
        featureTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        featureTableViewer.setInput((Object)this.values);
        if (!this.values.getChildren().isEmpty()) {
            featureTableViewer.setSelection((ISelection)new StructuredSelection(this.values.getChildren().get(0)));
        }
        this.setTableViewerListener(choiceTableViewer, featureTableViewer, addButton, removeButton);
        this.setUpButtonListener(upButton, featureTableViewer);
        this.setDownButtonListener(downButton, featureTableViewer);
        this.setAddButtonListener(addButton, choiceTableViewer, featureTableViewer, choiceText);
        this.setRemoveButtonListener(removeButton, choiceTableViewer, featureTableViewer, choiceText);
        return contents;
    }

    private Text createChoiceText(Composite parent, int style) {
        Text choiceText;
        Text text = choiceText = this.choices == null ? new Text(parent, style) : null;
        if (choiceText != null) {
            GridData choiceTextGridData = new GridData();
            choiceTextGridData.widthHint = Display.getCurrent().getBounds().width / 5;
            choiceTextGridData.verticalAlignment = 1;
            choiceTextGridData.horizontalAlignment = 4;
            choiceTextGridData.grabExcessHorizontalSpace = true;
            if (this.multiLine) {
                choiceTextGridData.verticalAlignment = 4;
                choiceTextGridData.grabExcessVerticalSpace = true;
            }
            choiceText.setLayoutData((Object)choiceTextGridData);
        }
        if (choiceText != null) {
            choiceText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if ((ExtendedFeatureEditorDialog.this.multiLine || event.character != '\r' && event.character != '\n') && event.character == '\u001b') {
                        choiceText.setText("");
                        event.doit = false;
                    }
                }
            });
        }
        return choiceText;
    }

    private Composite createChoiceComposite(Composite contents) {
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(this.choices == null ? EMFEditUIPlugin.INSTANCE.getString("_UI_Value_label") : EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_label"));
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        return choiceComposite;
    }

    private Composite createFeatureComposite(Composite contents) {
        Composite featureComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        featureComposite.setLayout((Layout)layout);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(this.extReference.getName());
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)featureLabelGridData);
        return featureComposite;
    }

    private Composite createControlButtonsArea(Composite parent) {
        Composite controlButtons = new Composite(parent, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        return controlButtons;
    }

    private Button createAddButton(Composite controlButtons) {
        Button addButton = new Button(controlButtons, 8);
        addButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Add_label"));
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)addButtonGridData);
        return addButton;
    }

    private Button createRemoveButton(Composite controlButtons) {
        Button removeButton = new Button(controlButtons, 8);
        removeButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Remove_label"));
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)removeButtonGridData);
        return removeButton;
    }

    private Button createUpButton(Composite controlButtons) {
        Button upButton = new Button(controlButtons, 8);
        upButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Up_label"));
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        upButton.setLayoutData((Object)upButtonGridData);
        return upButton;
    }

    private Button createDownButton(Composite controlButtons) {
        Button downButton = new Button(controlButtons, 8);
        downButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Down_label"));
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        downButton.setLayoutData((Object)downButtonGridData);
        return downButton;
    }

    private void setUpButtonListener(Button upButton, final TableViewer featureTableViewer) {
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                int minIndex = 0;
                for (Object value : selection) {
                    int index = ExtendedFeatureEditorDialog.this.values.getChildren().indexOf(value);
                    ExtendedFeatureEditorDialog.this.values.getChildren().move(Math.max(index - 1, minIndex++), value);
                }
            }
        });
    }

    private void setDownButtonListener(Button downButton, final TableViewer featureTableViewer) {
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                int maxIndex = ExtendedFeatureEditorDialog.this.values.getChildren().size() - selection.size();
                for (Object value : selection) {
                    int index = ExtendedFeatureEditorDialog.this.values.getChildren().indexOf(value);
                    ExtendedFeatureEditorDialog.this.values.getChildren().move(Math.min(index + 1, maxIndex++), value);
                }
            }
        });
    }

    private void setAddButtonListener(Button addButton, final TableViewer choiceTableViewer, final TableViewer featureTableViewer, final Text choiceText) {
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (choiceTableViewer != null) {
                    IStructuredSelection selection = (IStructuredSelection)choiceTableViewer.getSelection();
                    for (Object value : selection) {
                        if (ExtendedFeatureEditorDialog.this.values.getChildren().contains(value)) continue;
                        ExtendedFeatureEditorDialog.this.values.getChildren().add(value);
                        choiceTableViewer.remove(value);
                    }
                    featureTableViewer.setSelection((ISelection)selection);
                }
            }
        });
    }

    private void setRemoveButtonListener(Button removeButton, final TableViewer choiceTableViewer, final TableViewer featureTableViewer, final Text choiceText) {
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                Object firstValue = null;
                for (Object value : selection) {
                    if (firstValue == null) {
                        firstValue = value;
                    }
                    ExtendedFeatureEditorDialog.this.values.getChildren().remove(value);
                    choiceTableViewer.add(value);
                }
                if (!ExtendedFeatureEditorDialog.this.values.getChildren().isEmpty()) {
                    featureTableViewer.setSelection((ISelection)new StructuredSelection(ExtendedFeatureEditorDialog.this.values.getChildren().get(0)));
                }
                if (choiceTableViewer != null) {
                    choiceTableViewer.setSelection((ISelection)selection);
                } else if (choiceText != null) {
                    // empty if block
                }
            }
        });
    }

    private void setTableViewerListener(TableViewer choiceTableViewer, TableViewer featureTableViewer, final Button addButton, final Button removeButton) {
        if (choiceTableViewer != null) {
            choiceTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (addButton.isEnabled()) {
                        addButton.notifyListeners(13, null);
                    }
                }
            });
            featureTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (removeButton.isEnabled()) {
                        removeButton.notifyListeners(13, null);
                    }
                }
            });
        }
    }

    protected void okPressed() {
        this.result = new BasicEList((Collection)this.values.getChildren());
        super.okPressed();
    }

    public boolean close() {
        this.contentProvider.dispose();
        return super.close();
    }

    public EList<EObject> getResult() {
        return this.result;
    }
}

