/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.text;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.PaperClipsUtil;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.SWTUtil;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class TextStyle {
    private FontData fontData;
    private RGB foreground;
    private RGB background;
    private int alignment;
    private boolean underline;
    private boolean strikeout;

    public TextStyle() {
        this.fontData = SWTUtil.copy(TextPrint.DEFAULT_FONT_DATA);
        this.foreground = new RGB(0, 0, 0);
        this.background = null;
        this.alignment = 16384;
        this.underline = false;
        this.strikeout = false;
    }

    private TextStyle(TextStyle that) {
        this.fontData = that.fontData;
        this.foreground = that.foreground;
        this.background = that.background;
        this.alignment = that.alignment;
        this.underline = that.underline;
        this.strikeout = that.strikeout;
    }

    private TextStyle internalFont(FontData fontData) {
        TextStyle result = new TextStyle(this);
        result.fontData = fontData;
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.alignment;
        result = 31 * result + (this.background == null ? 0 : this.background.hashCode());
        result = 31 * result + (this.fontData == null ? 0 : this.fontData.hashCode());
        result = 31 * result + (this.foreground == null ? 0 : this.foreground.hashCode());
        result = 31 * result + (this.strikeout ? 1231 : 1237);
        result = 31 * result + (this.underline ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextStyle other = (TextStyle)obj;
        if (this.alignment != other.alignment) {
            return false;
        }
        if (this.background == null ? other.background != null : !this.background.equals((Object)other.background)) {
            return false;
        }
        if (this.fontData == null ? other.fontData != null : !this.fontData.equals((Object)other.fontData)) {
            return false;
        }
        if (this.foreground == null ? other.foreground != null : !this.foreground.equals((Object)other.foreground)) {
            return false;
        }
        if (this.strikeout != other.strikeout) {
            return false;
        }
        return this.underline == other.underline;
    }

    public TextStyle font(String name, int height, int style) {
        return this.internalFont(new FontData(name, height, style));
    }

    public TextStyle font(FontData fontData) {
        return this.internalFont(SWTUtil.copy(fontData));
    }

    public TextStyle fontName(String name) {
        return this.font(name, this.fontData.getHeight(), this.fontData.getStyle());
    }

    public TextStyle fontHeight(int height) {
        return this.font(this.fontData.getName(), height, this.fontData.getStyle());
    }

    public TextStyle fontStyle(int style) {
        return this.font(this.fontData.getName(), this.fontData.getHeight(), style);
    }

    private TextStyle internalForeground(RGB foreground) {
        TextStyle result = new TextStyle(this);
        result.foreground = foreground;
        return result;
    }

    public TextStyle foreground(RGB foreground) {
        return this.internalForeground(SWTUtil.copy(foreground));
    }

    public TextStyle foreground(int red, int green, int blue) {
        return this.internalForeground(new RGB(red, green, blue));
    }

    public TextStyle foreground(int rgb) {
        return this.internalForeground(SWTUtil.deriveRGB(rgb));
    }

    private TextStyle internalBackground(RGB background) {
        TextStyle result = new TextStyle(this);
        result.background = background;
        return result;
    }

    public TextStyle background(RGB background) {
        return this.internalBackground(SWTUtil.copy(background));
    }

    public TextStyle background(int red, int green, int blue) {
        return this.internalBackground(new RGB(red, green, blue));
    }

    public TextStyle background(int rgb) {
        return this.internalBackground(SWTUtil.deriveRGB(rgb));
    }

    public TextStyle align(int alignment) {
        TextStyle result = new TextStyle(this);
        result.alignment = PaperClipsUtil.firstMatch(alignment, new int[]{16384, 0x1000000, 131072}, 16384);
        return result;
    }

    public TextStyle underline() {
        return this.underline(true);
    }

    public TextStyle underline(boolean underline) {
        TextStyle result = new TextStyle(this);
        result.underline = underline;
        return result;
    }

    public TextStyle strikeout() {
        return this.strikeout(true);
    }

    public TextStyle strikeout(boolean strikeout) {
        TextStyle result = new TextStyle(this);
        result.strikeout = strikeout;
        return result;
    }

    public FontData getFontData() {
        return SWTUtil.copy(this.fontData);
    }

    public RGB getForeground() {
        return SWTUtil.copy(this.foreground);
    }

    public RGB getBackground() {
        return SWTUtil.copy(this.background);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public boolean getStrikeout() {
        return this.strikeout;
    }

    public TextPrint create(String text) {
        return new TextPrint(text, this);
    }
}

