/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.properties.EditSupport;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.internal.EditSupportSpec;
import org.eclipse.sirius.properties.core.internal.SiriusContext;
import org.eclipse.sirius.properties.defaultrules.api.DefaultRulesProvider;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class SiriusToolServices {
    public EObject executeOperation(SiriusInputDescriptor self, EObject eObject, String initialCommandUri) {
        ModelOperation modelOperation;
        Session session;
        if (!eObject.eIsProxy() && (session = new EObjectQuery(eObject).getSession()) != null && (modelOperation = this.findModelOperation(initialCommandUri, session)) != null) {
            ModelAccessor modelAccessor = session.getModelAccessor();
            ICommandTask task = new TaskHelper(modelAccessor, SiriusPlugin.getDefault().getUiCallback()).buildTaskFromModelOperation(eObject, modelOperation);
            SiriusCommand command = new SiriusCommand(session.getTransactionalEditingDomain(), "SiriusToolServices#executeOperation");
            command.getTasks().add(task);
            try {
                try {
                    if (command.canExecute()) {
                        command.execute();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    command.dispose();
                }
            }
            finally {
                command.dispose();
            }
        }
        return eObject;
    }

    private ModelOperation findModelOperation(String initialCommandUri, Session session) {
        URI commandResourceURI = URI.createURI((String)initialCommandUri).trimFragment();
        for (Resource res : this.getResourcesInScope(session)) {
            EObject modelOperationEObject;
            if (!commandResourceURI.equals(res.getURI()) || !((modelOperationEObject = res.getEObject(URI.createURI((String)initialCommandUri).fragment())) instanceof InitialOperation)) continue;
            return ((InitialOperation)modelOperationEObject).getFirstModelOperations();
        }
        return null;
    }

    private Set<Resource> getResourcesInScope(Session session) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        Collection selectedViewpoints = session.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : selectedViewpoints) {
            Resource eResource = viewpoint.eResource();
            if (eResource == null) continue;
            result.add(eResource);
        }
        ViewExtensionDescription defaults = DefaultRulesProvider.INSTANCE.getDefaultRules();
        if (defaults != null && defaults.eResource() != null) {
            result.add(defaults.eResource());
        }
        return result;
    }

    public SiriusContext context(SiriusInputDescriptor sid) {
        return sid.getFullContext();
    }

    public EObject getSemanticElement(SiriusInputDescriptor sid) {
        return sid.getSemanticElement();
    }

    public Set<EObject> getAllSemanticElements(SiriusInputDescriptor sid) {
        return sid.getAllSemanticElements();
    }

    public Object getOriginalSelection(SiriusInputDescriptor sid) {
        return sid.getOriginalSelection();
    }

    public Session session(SiriusContext ctx) {
        Option<Session> s = ctx.getSession();
        if (s.some()) {
            return (Session)s.get();
        }
        return null;
    }

    public DRepresentation representation(SiriusContext ctx) {
        Option<DRepresentation> r = ctx.getDRepresentation();
        if (r.some()) {
            return (DRepresentation)r.get();
        }
        return null;
    }

    public DSemanticDecorator semanticDecorator(SiriusContext ctx) {
        return ctx.getSemanticDecorator();
    }

    public EObject mainSemanticElement(SiriusContext ctx) {
        Option<EObject> target = ctx.getMainSemanticElement();
        if (target.some()) {
            return (EObject)target.get();
        }
        return null;
    }

    public List<EObject> allSemanticElements(SiriusContext ctx) {
        Option<List<EObject>> elements = ctx.getAdditionalSemanticElements();
        if (elements.some()) {
            return (List)elements.get();
        }
        return null;
    }

    public EditSupport emfEditServices(SiriusInputDescriptor input, EObject self) {
        EditSupportSpec ess = new EditSupportSpec(input.getFullContext(), self);
        return ess;
    }
}

