/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;

public class LayoutAlgorithmResolver
implements IGraphElementVisitor {
    @Override
    public void visit(ElkGraphElement element) {
        if (element instanceof ElkNode && !((Boolean)element.getProperty(CoreOptions.NO_LAYOUT)).booleanValue()) {
            this.resolveAlgorithm((ElkNode)element);
        }
    }

    protected void resolveAlgorithm(ElkNode node) {
        String algorithmId = (String)node.getProperty(CoreOptions.ALGORITHM);
        if (this.resolveAndSetAlgorithm(algorithmId, node)) {
            return;
        }
        if (this.mustResolve(node)) {
            if (algorithmId == null || algorithmId.trim().isEmpty()) {
                String defaultAlgorithmId = this.getDefaultLayoutAlgorithmID();
                if (!this.resolveAndSetAlgorithm(this.getDefaultLayoutAlgorithmID(), node)) {
                    StringBuilder message = new StringBuilder("Unable to load default layout algorithm ").append(defaultAlgorithmId).append(" for unconfigured node ");
                    ElkUtil.printElementPath((ElkGraphElement)node, message);
                    throw new UnsupportedConfigurationException(message.toString());
                }
            } else {
                StringBuilder message = new StringBuilder("Layout algorithm '").append(algorithmId).append("' not found for ");
                ElkUtil.printElementPath((ElkGraphElement)node, message);
                throw new UnsupportedConfigurationException(message.toString());
            }
        }
    }

    protected boolean resolveAndSetAlgorithm(String algorithmId, ElkNode node) {
        LayoutAlgorithmData algorithmData = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(algorithmId);
        if (algorithmData != null) {
            node.setProperty(CoreOptions.RESOLVED_ALGORITHM, (Object)algorithmData);
            return true;
        }
        return false;
    }

    protected boolean mustResolve(ElkNode node) {
        return !node.hasProperty(CoreOptions.RESOLVED_ALGORITHM) && (!node.getChildren().isEmpty() || (Boolean)node.getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false);
    }

    public String getDefaultLayoutAlgorithmID() {
        return "org.eclipse.elk.layered";
    }
}

