/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.editor;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.tests.swtbot.support.api.condition.SameScreenBoundsCondition;
import org.eclipse.sirius.tests.swtbot.support.api.widget.SWTBotSiriusFigureCanvas;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefFigureCanvas;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefViewer;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.junit.Assert;

public class SWTBotSiriusGefViewer
extends SWTBotGefViewer {
    public SWTBotSiriusGefViewer(GraphicalViewer graphicalViewer) throws WidgetNotFoundException {
        super(graphicalViewer);
        this.init();
    }

    protected void init() throws WidgetNotFoundException {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IAdaptable adaptable;
                Object adapter;
                Control control = SWTBotSiriusGefViewer.this.graphicalViewer.getControl();
                if (control instanceof FigureCanvas) {
                    SWTBotSiriusGefViewer.this.canvas = new SWTBotSiriusFigureCanvas((FigureCanvas)control);
                } else if (control instanceof Canvas && control instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)control).getAdapter(LightweightSystem.class)) instanceof LightweightSystem) {
                    SWTBotSiriusGefViewer.this.canvas = new SWTBotSiriusFigureCanvas((Canvas)control, (LightweightSystem)adapter);
                }
                SWTBotSiriusGefViewer.this.editDomain = SWTBotSiriusGefViewer.this.graphicalViewer.getEditDomain();
            }
        });
        if (this.graphicalViewer == null) {
            throw new WidgetNotFoundException("Editor does not adapt to a GraphicalViewer");
        }
    }

    public SWTBotGefFigureCanvas getCanvas() {
        return super.getCanvas();
    }

    public SWTBotGefEditPart getPaletteRootEditPartBot() {
        Object o = UIThreadRunnable.syncExec((Result)new Result<Object>(){

            public Object run() {
                return SWTBotSiriusGefViewer.this.createEditPart((EditPart)SWTBotSiriusGefViewer.this.editDomain.getPaletteViewer().getRootEditPart());
            }
        });
        if (o instanceof WidgetNotFoundException) {
            throw (WidgetNotFoundException)((Object)o);
        }
        return (SWTBotGefEditPart)o;
    }

    public SWTBotGefEditPart getSiriusPaletteGroupEditPartBot() {
        SWTBotGefEditPart viewpointPaletteGrouEditPartBot = null;
        Object o = UIThreadRunnable.syncExec((Result)new Result<Object>(){

            public Object run() {
                return SWTBotSiriusGefViewer.this.createEditPart((EditPart)SWTBotSiriusGefViewer.this.editDomain.getPaletteViewer().getRootEditPart());
            }
        });
        if (o instanceof WidgetNotFoundException) {
            throw (WidgetNotFoundException)((Object)o);
        }
        SWTBotGefEditPart paletteRootEditPartBot = (SWTBotGefEditPart)o;
        Assert.assertFalse((String)"The rootEditPart of the palette should contains a SlidablePaletteEditPart", (boolean)paletteRootEditPartBot.children().isEmpty());
        SWTBotGefEditPart slidablePaletteEditPartBot = (SWTBotGefEditPart)paletteRootEditPartBot.children().get(0);
        if (slidablePaletteEditPartBot.children().size() >= 2) {
            viewpointPaletteGrouEditPartBot = (SWTBotGefEditPart)slidablePaletteEditPartBot.children().get(1);
        }
        return viewpointPaletteGrouEditPartBot;
    }

    public void reveal(String label) {
        final SWTBotGefEditPart revealedEP = this.getEditpart(label, this.mainEditPart().children());
        if (revealedEP == null) {
            throw new WidgetNotFoundException(String.format("Expected to find widget %s", label));
        }
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SWTBotSiriusGefViewer.this.graphicalViewer.reveal(revealedEP.part());
            }
        });
    }

    public void reveal(final EditPart revealedEP) {
        if (revealedEP == null) {
            throw new WidgetNotFoundException(String.format("Expected to find widget %s", revealedEP));
        }
        Rectangle initialBounds = Rectangle.SINGLETON;
        if (revealedEP instanceof IGraphicalEditPart) {
            initialBounds = ((IGraphicalEditPart)revealedEP).getFigure().getBounds().getCopy();
            GraphicalHelper.logical2screen((Rectangle)initialBounds, (IGraphicalEditPart)((IGraphicalEditPart)revealedEP));
        }
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SWTBotSiriusGefViewer.this.graphicalViewer.reveal(revealedEP);
            }
        });
        if (revealedEP instanceof IGraphicalEditPart) {
            this.bot().waitUntil((ICondition)new SameScreenBoundsCondition((IGraphicalEditPart)revealedEP, initialBounds));
        }
    }

    private int verifyScrollBarOffset(RangeModel model, int value) {
        int newValue = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum() - model.getExtent(), newValue);
    }

    public void scrollTo(Point location) {
        this.scrollTo(location.x, location.y);
    }

    public void scrollTo(final int x, final int y) {
        if (this.graphicalViewer.getControl() instanceof FigureCanvas) {
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    ((FigureCanvas)SWTBotSiriusGefViewer.this.graphicalViewer.getControl()).scrollTo(x, y);
                }
            });
        }
    }

    private boolean isLabel(IFigure figure, String label) {
        boolean result = false;
        if (figure instanceof Label && ((Label)figure).getText().equals(label)) {
            result = true;
        } else if (figure instanceof TextFlow && ((TextFlow)figure).getText().equals(label)) {
            result = true;
        } else if (figure instanceof SiriusWrapLabel && ((SiriusWrapLabel)figure).getText().equals(label)) {
            result = true;
        }
        return result;
    }

    public SWTBotGefEditPart getEditPart(String label) {
        List allEditParts = this.mainEditPart().children();
        allEditParts.addAll(this.mainEditPart().sourceConnections());
        return this.getEditpart(label, allEditParts);
    }

    public SWTBotGefEditPart getEditpart(String label, List<SWTBotGefEditPart> allEditParts) {
        SWTBotGefEditPart result = null;
        Iterator<SWTBotGefEditPart> iterator = allEditParts.iterator();
        while (iterator.hasNext() && result == null) {
            SWTBotGefEditPart child = iterator.next();
            IFigure figure = ((GraphicalEditPart)child.part()).getFigure();
            if (this.isLabel(figure, label)) {
                result = child;
                continue;
            }
            SWTBotGefEditPart childEditPart = this.getEditPart(child, label);
            if (childEditPart != null) {
                result = childEditPart;
                continue;
            }
            if (!this.findLabelFigure(figure, label)) continue;
            result = child;
        }
        return result;
    }

    private boolean findLabelFigure(IFigure figure, String label) {
        boolean result = false;
        if (this.isLabel(figure, label)) {
            result = true;
        } else {
            Iterator iteratorFigureChildren = figure.getChildren().iterator();
            while (iteratorFigureChildren.hasNext() && !result) {
                Object figureChild = iteratorFigureChildren.next();
                if (!this.isLabel((IFigure)figureChild, label) && !this.findLabelFigure((IFigure)figureChild, label)) continue;
                result = true;
            }
        }
        return result;
    }

    private SWTBotGefEditPart getEditPart(SWTBotGefEditPart editPart, String label) {
        if (editPart.children().isEmpty() && this.findLabelFigure(((GraphicalEditPart)editPart.part()).getFigure(), label)) {
            return editPart;
        }
        List allEditParts = editPart.children();
        allEditParts.addAll(editPart.sourceConnections());
        return this.getEditpart(label, allEditParts);
    }

    @Deprecated
    public void dragWithKey(int fromXPosition, int fromYPosition, int toXPosition, int toYPosition, int keyCode, AtomicBoolean dragFinished) {
        if (this.canvas instanceof SWTBotSiriusFigureCanvas) {
            ((SWTBotSiriusFigureCanvas)this.canvas).mouseDragWithKey(fromXPosition, fromYPosition, toXPosition, toYPosition, keyCode, dragFinished);
        } else {
            this.canvas.mouseDrag(fromXPosition, fromYPosition, toXPosition, toYPosition);
        }
    }

    public void dragWithKeys(int fromXPosition, int fromYPosition, int toXPosition, int toYPosition, AtomicBoolean dragFinished, int ... keyModifiers) {
        if (this.canvas instanceof SWTBotSiriusFigureCanvas) {
            ((SWTBotSiriusFigureCanvas)this.canvas).mouseDragWithKeys(fromXPosition, fromYPosition, toXPosition, toYPosition, dragFinished, keyModifiers);
        } else {
            this.canvas.mouseDrag(fromXPosition, fromYPosition, toXPosition, toYPosition);
        }
    }

    public void mouseScrollWithKey(int xPosition, int yPosition, int keyCode, int zoomIncrement) {
        if (!(this.canvas instanceof SWTBotSiriusFigureCanvas)) {
            throw new UnsupportedOperationException("This method is supported only by SWTBotSiriusFigureCanvas canvas and not by " + this.canvas.getClass().getSimpleName());
        }
        ((SWTBotSiriusFigureCanvas)this.canvas).mouseScrollWithKey(xPosition, yPosition, keyCode, zoomIncrement);
    }

    public void click(int xPosition, int yPosition, boolean displayFeedback) {
        if (this.canvas instanceof SWTBotSiriusFigureCanvas) {
            ((SWTBotSiriusFigureCanvas)this.canvas).mouseMoveLeftClick(xPosition, yPosition, displayFeedback);
        } else {
            this.canvas.mouseMoveLeftClick(xPosition, yPosition);
        }
    }

    public void click(int xPosition, int yPosition, boolean displayFeedback, int[] keyModifiers) {
        if (this.canvas instanceof SWTBotSiriusFigureCanvas) {
            ((SWTBotSiriusFigureCanvas)this.canvas).mouseMoveLeftClick(xPosition, yPosition, displayFeedback, keyModifiers);
        } else {
            this.canvas.mouseMoveLeftClick(xPosition, yPosition);
        }
    }
}

