/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.e3.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.SearchPattern;

public class PatternFilter
extends ViewerFilter {
    private static final Pattern NON_WORD = Pattern.compile("\\W+", 256);
    private Map cache = new HashMap();
    private Map foundAnyCache = new HashMap();
    private boolean useCache = false;
    private boolean includeLeadingWildcard = false;
    private SearchPattern matcher;
    private boolean useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null && this.useEarlyReturnIfMatcherIsNull) {
            return elements;
        }
        if (!this.useCache) {
            return super.filter(viewer, parent, elements);
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = (Boolean)this.foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null) {
            return true;
        }
        if (!this.useCache) {
            return this.computeAnyVisible(viewer, elements);
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = (Boolean)this.foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || patternString.equals("")) {
            this.matcher = null;
        } else {
            String pattern = String.valueOf(patternString) + "*";
            if (this.includeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this.matcher = new SearchPattern();
            this.matcher.setPattern(pattern);
        }
    }

    void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.matches(string);
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    protected boolean wordMatches(String text) {
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] words = NON_WORD.split(text);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (this.match(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }
}

